#include <stdio.h>
#include <errno.h>
#include <ipc/ipc.h>
#include <fcntl.h>
#include <malloc.h>

static int write_all(int fd, void *data, size_t len)
{
	int cnt = 0;

	do {
		data += cnt;
		len -= cnt;
		cnt = write(fd, data, len);
	} while (cnt > 0 && (len - cnt) > 0);

	if (cnt < 0)
		return cnt;

	if (len - cnt > 0)
		return EIO;

	return EOK;
}

static int write_tom()
{
	size_t len = sizeof(int) * 1000000;
	int *tmp = malloc(len);
	int fd = open("/tom", O_CREAT | O_WRONLY);
	if (fd <= 0) {
		free(tmp);
		return -1;
	}

	size_t chunk_size = 32 * 1024;
    size_t nread = 0;
    while (nread < len) {
            if (len - nread < chunk_size)
                chunk_size = len - nread;
			printf("CHECKPOINTER: Writing chunk, nread: %p\n", nread);
            nread += chunk_size;
            int rc = write_all(fd, tmp, chunk_size);
            if (rc < 0) {
				free(tmp);
				return rc;
            }
	}

	free(tmp);
	return 0;

}

int main(int argc, char **argv)
{
	int rc = write_tom();
	printf("rc: %i\n", rc);
	return 0;
}
