/*
 * Copyright (c) 2005 Jakub Jermar
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup sparc64interrupt
 * @{
 */
/**
 * @file
 */

#ifndef KERN_sparc64_EXCEPTION_H_
#define KERN_sparc64_EXCEPTION_H_

#define TT_INSTRUCTION_ACCESS_EXCEPTION		0x08
#define TT_INSTRUCTION_ACCESS_ERROR		0x0a
#define TT_ILLEGAL_INSTRUCTION			0x10
#define TT_PRIVILEGED_OPCODE			0x11
#define TT_UNIMPLEMENTED_LDD			0x12
#define TT_UNIMPLEMENTED_STD			0x13
#define TT_FP_DISABLED				0x20
#define TT_FP_EXCEPTION_IEEE_754		0x21
#define TT_FP_EXCEPTION_OTHER			0x22
#define TT_TAG_OVERFLOW				0x23
#define TT_DIVISION_BY_ZERO			0x28
#define TT_DATA_ACCESS_EXCEPTION		0x30
#define TT_DATA_ACCESS_ERROR			0x32
#define TT_MEM_ADDRESS_NOT_ALIGNED		0x34
#define TT_LDDF_MEM_ADDRESS_NOT_ALIGNED		0x35
#define TT_STDF_MEM_ADDRESS_NOT_ALIGNED		0x36
#define TT_PRIVILEGED_ACTION			0x37
#define TT_LDQF_MEM_ADDRESS_NOT_ALIGNED		0x38
#define TT_STQF_MEM_ADDRESS_NOT_ALIGNED		0x39

#ifndef __ASM__

#include <arch/interrupt.h>

extern void dump_istate(istate_t *istate);

extern void instruction_access_exception(int n, istate_t *istate);
extern void instruction_access_error(int n, istate_t *istate);
extern void illegal_instruction(int n, istate_t *istate);
extern void privileged_opcode(int n, istate_t *istate);
extern void unimplemented_LDD(int n, istate_t *istate);
extern void unimplemented_STD(int n, istate_t *istate);
extern void fp_disabled(int n, istate_t *istate);
extern void fp_exception_ieee_754(int n, istate_t *istate);
extern void fp_exception_other(int n, istate_t *istate);
extern void tag_overflow(int n, istate_t *istate);
extern void division_by_zero(int n, istate_t *istate);
extern void data_access_exception(int n, istate_t *istate);
extern void data_access_error(int n, istate_t *istate);
extern void mem_address_not_aligned(int n, istate_t *istate);
extern void LDDF_mem_address_not_aligned(int n, istate_t *istate);
extern void STDF_mem_address_not_aligned(int n, istate_t *istate);
extern void privileged_action(int n, istate_t *istate);
extern void LDQF_mem_address_not_aligned(int n, istate_t *istate);
extern void STQF_mem_address_not_aligned(int n, istate_t *istate);

#endif /* !__ASM__ */

#endif

/** @}
 */
