/*
 * Copyright (c) 2012 Vojtech Horky
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup logset
 * @{
 */
/** @file Change logger behavior.
 */
#include <stdio.h>
#include <async.h>
#include <errno.h>
#include <str_error.h>
#include <io/logctl.h>

int main(int argc, char *argv[])
{
	/* The only action is to set default logging level. */

	if (argc < 2) {
		fprintf(stderr, "Usage: %s <default-logging-level>\n", argv[0]);
		return 1;
	}

	log_level_t new_default_level;
	int rc = log_level_from_str(argv[1], &new_default_level);
	if (rc != EOK) {
		fprintf(stderr, "Unrecognised log level '%s': %s.\n",
		    argv[1], str_error(rc));
	}

	rc = logctl_set_default_level(new_default_level);

	if (rc != EOK) {
		fprintf(stderr, "Failed to change default logging level: %s.\n",
		    str_error(rc));
		return 2;
	}

	return 0;
}

/** @}
 */
