#!/bin/sh

#
# Copyright (c) 2014 Vojtech Horky
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# - Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
# - Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in the
#   documentation and/or other materials provided with the distribution.
# - The name of the author may not be used to endorse or promote products
#   derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

run_echo() {
	echo "[exec]:" "$@"
	"$@"
}

RUN=run_echo


# Because of the very first command we issue that deletes about everything
if ! [ "$1" == "really-overwrite" ]; then
	echo "Wrong argument, see sources!"
	exit 1
fi

$RUN find -not -name update-from-master.sh -delete
$RUN wget -q https://github.com/vhotspur/pcut/archive/master.zip -O pcut-master.zip
$RUN unzip -q -u pcut-master.zip
$RUN mv -f pcut-master/* .
$RUN rm -rf pcut-master pcut-master.zip
$RUN rm -rf contrib doc
$RUN rm -f CMakeLists.txt *.cmake run_test.sh

cat >Makefile <<'EOF_MAKEFILE_HEAD'
#
# This file was generated by call to update-from-master.sh
#

USPACE_PREFIX = ../..
PCUT_TEST_PREFIX = test-libpcut-

SELF_TESTS = \
EOF_MAKEFILE_HEAD

for testfile in tests/*.expected; do
	testname=`basename "$testfile" .expected`
	echo "	\$(PCUT_TEST_PREFIX)${testname}\$(PCUT_TEST_SUFFIX) \\"
done | sed '$s/\\$//' >>Makefile

cat >>Makefile <<'EOF_MAKEFILE_TAIL'

EXTRA_CLEAN = $(SELF_TESTS)

include helenos.mak

include $(USPACE_PREFIX)/Makefile.common

include helenos.test.mak

all-test: $(SELF_TESTS)

test-libpcut-%: $(LIBRARY).a
	$(CC) $(CFLAGS) $(LDFLAGS) -o $@ $(STARTUP_OBJECT) $^ $(LIBRARY).a $(BASE_LIBS)

EOF_MAKEFILE_TAIL
