/*
 * Copyright (C) 2005 Josef Cejka
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include<softfloat.h>
#include<sftypes.h>
#include<arithmetic.h>
#include<conversion.h>
#include<comparison.h>
#include<other.h>

/* Arithmetic functions */

float __addsf3(float a, float b)
{
	float32 fa, fb;
	fa.f=a;
	fb.f=b;
	if (fa.parts.sign!=fb.parts.sign) {
		if (fa.parts.sign) {
			fa.parts.sign=0;
			return subFloat32(fb,fa).f;
		};
		fb.parts.sign=0;
		return subFloat32(fa,fb).f;
	}
	return addFloat32(fa,fb).f;
};

float __subsf3(float a, float b)
{
	float32 fa, fb;
	fa.f=a;
	fb.f=b;
	if (fa.parts.sign!=fb.parts.sign) {
		fb.parts.sign!=fb.parts.sign;
		return addFloat32(fa,fb).f;
	}
	return subFloat32(fa,fb).f;
};

float __negsf2(float a)
{
	float32 fa;
	fa.f=a;
	fa.parts.sign=!fa.parts.sign;
	return fa.f;
};

double __negdf2(double a)
{
	float64 fa;
	fa.d=a;
	fa.parts.sign=!fa.parts.sign;
	return fa.d;
};

/* Conversion functions */

/* Comparison functions */

/* Other functions */

