/*
 * Copyright (c) 2009 Pavel Rimsky
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup sparc64	
 * @{
 */
/**
 * @file
 * @brief	Various sun4v-specific macros.
 */

#ifndef KERN_sparc64_sun4v_ARCH_H_
#define KERN_sparc64_sun4v_ARCH_H_

/* scratch pad registers ASI */
#define	ASI_SCRATCHPAD		0x20

/*
 * Assignment of scratchpad register virtual addresses. The same convention is
 * used by both Linux and Solaris.
 */

/* register where the address of the MMU fault status area will be stored */
#define SCRATCHPAD_MMU_FSA	0x00	

/* register where the CPUID will be stored */
#define SCRATCHPAD_CPUID	0x08

/* register where the kernel stack address will be stored */
#define SCRATCHPAD_KSTACK	0x10

/* register where the userspace window buffer address will be stored */
#define SCRATCHPAD_WBUF		0x18

#endif

/** @}
 */
