/*
 * Copyright (c) 2025 Jiri Svoboda
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup nav
 * @{
 */
/**
 * @file Navigator menu types
 */

#ifndef TYPES_MENU_H
#define TYPES_MENU_H

#include <ui/menubar.h>
#include <ui/ui.h>
#include <ui/window.h>

/** Navigator menu callbacks */
typedef struct nav_menu_cb {
	/** File / Open */
	void (*file_open)(void *);
	/** File / Edit */
	void (*file_edit)(void *);
	/** File / Exit */
	void (*file_exit)(void *);
} nav_menu_cb_t;

/** Navigator menu */
typedef struct nav_menu {
	/** UI */
	ui_t *ui;
	/** Containing window */
	ui_window_t *window;
	/** Menu bar */
	ui_menu_bar_t *menubar;
	/** Callbacks */
	nav_menu_cb_t *cb;
	/** Callback argument */
	void *cb_arg;
} nav_menu_t;

#endif

/** @}
 */
