/*
 * Copyright (c) 2000 Dmitry Bolkhovityanov
 * Copyright (c) 2009 Martin Decky
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup genarch
 * @{
 */
/** @file
 */

#include <stdint.h>
#include "font-8x16.h"

/** Convert character to font glyph index
 *
 * The font does not cover all Unicode characters.
 * This function converts the character to an appropriate
 * glyph in the font or returns an index to the question
 * mark glyph if no specific glyph exists.
 *
 * If found is not null, indicate whether the glyph was found or not.
 *
 */
uint16_t fb_font_glyph(const wchar_t ch, bool *found)
{
	if (found)
		*found = true;

	if (ch == 0x0000)
		return 0;

	if ((ch >= 0x0020) && (ch <= 0x007f))
		return (ch - 32);

	if ((ch >= 0x00a0) && (ch <= 0x021f))
		return (ch - 64);

	if ((ch >= 0x0222) && (ch <= 0x0233))
		return (ch - 66);

	if ((ch >= 0x0250) && (ch <= 0x02ad))
		return (ch - 94);

	if ((ch >= 0x02b0) && (ch <= 0x02cf))
		return (ch - 96);

	if ((ch >= 0x02d8) && (ch <= 0x02dd))
		return (ch - 104);

	if (ch == 0x02ee)
		return 630;

	if ((ch >= 0x0300) && (ch <= 0x0301))
		return (ch - 137);

	if (ch == 0x0303)
		return 633;

	if (ch == 0x0309)
		return 634;

	if ((ch >= 0x0312) && (ch <= 0x0314))
		return (ch - 151);

	if (ch == 0x0323)
		return 638;

	if ((ch >= 0x0340) && (ch <= 0x0341))
		return (ch - 193);

	if ((ch >= 0x0374) && (ch <= 0x0375))
		return (ch - 243);

	if (ch == 0x037a)
		return 643;

	if (ch == 0x037e)
		return 644;

	if ((ch >= 0x0384) && (ch <= 0x038a))
		return (ch - 255);

	if (ch == 0x038c)
		return 652;

	if ((ch >= 0x038e) && (ch <= 0x03a1))
		return (ch - 257);

	if ((ch >= 0x03a3) && (ch <= 0x03ce))
		return (ch - 258);

	if ((ch >= 0x03d0) && (ch <= 0x03d7))
		return (ch - 259);

	if ((ch >= 0x03da) && (ch <= 0x03f3))
		return (ch - 261);

	if ((ch >= 0x0400) && (ch <= 0x0486))
		return (ch - 273);

	if ((ch >= 0x0488) && (ch <= 0x04ce))
		return (ch - 274);

	if ((ch >= 0x04d0) && (ch <= 0x04f5))
		return (ch - 275);

	if ((ch >= 0x04f8) && (ch <= 0x04f9))
		return (ch - 277);

	if ((ch >= 0x0500) && (ch <= 0x050f))
		return (ch - 283);

	if ((ch >= 0x0530) && (ch <= 0x0556))
		return (ch - 315);

	if ((ch >= 0x0559) && (ch <= 0x055f))
		return (ch - 317);

	if ((ch >= 0x0561) && (ch <= 0x0587))
		return (ch - 318);

	if ((ch >= 0x0589) && (ch <= 0x058a))
		return (ch - 319);

	if ((ch >= 0x0591) && (ch <= 0x05a1))
		return (ch - 325);

	if ((ch >= 0x05a3) && (ch <= 0x05b9))
		return (ch - 326);

	if ((ch >= 0x05bb) && (ch <= 0x05c4))
		return (ch - 327);

	if ((ch >= 0x05d0) && (ch <= 0x05ea))
		return (ch - 338);

	if ((ch >= 0x05f0) && (ch <= 0x05f4))
		return (ch - 343);

	if (ch == 0x060c)
		return 1182;

	if (ch == 0x061b)
		return 1183;

	if (ch == 0x061f)
		return 1184;

	if ((ch >= 0x0621) && (ch <= 0x063a))
		return (ch - 384);

	if ((ch >= 0x0640) && (ch <= 0x0655))
		return (ch - 389);

	if ((ch >= 0x0660) && (ch <= 0x066d))
		return (ch - 399);

	if ((ch >= 0x0670) && (ch <= 0x06ed))
		return (ch - 401);

	if ((ch >= 0x06f0) && (ch <= 0x06fe))
		return (ch - 403);

	if (ch == 0x10d3)
		return 1388;

	if (ch == 0x10d7)
		return 1389;

	if (ch == 0x10da)
		return 1390;

	if (ch == 0x10dd)
		return 1391;

	if (ch == 0x10e6)
		return 1392;

	if ((ch >= 0x1e00) && (ch <= 0x1e9b))
		return (ch - 6287);

	if ((ch >= 0x1ea0) && (ch <= 0x1ef9))
		return (ch - 6291);

	if ((ch >= 0x1f00) && (ch <= 0x1f07))
		return (ch - 6297);

	if ((ch >= 0x2000) && (ch <= 0x2027))
		return (ch - 6545);

	if ((ch >= 0x2030) && (ch <= 0x2046))
		return (ch - 6553);

	if ((ch >= 0x2048) && (ch <= 0x204d))
		return (ch - 6554);

	if (ch == 0x2070)
		return 1716;

	if ((ch >= 0x2074) && (ch <= 0x208f))
		return (ch - 6591);

	if ((ch >= 0x20a0) && (ch <= 0x20af))
		return (ch - 6607);

	if ((ch >= 0x2100) && (ch <= 0x213a))
		return (ch - 6687);

	if ((ch >= 0x2153) && (ch <= 0x2183))
		return (ch - 6711);

	if ((ch >= 0x2190) && (ch <= 0x21f3))
		return (ch - 6723);

	if ((ch >= 0x2200) && (ch <= 0x22f1))
		return (ch - 6735);

	if (ch == 0x2300)
		return 2211;

	if (ch == 0x2302)
		return 2212;

	if ((ch >= 0x2308) && (ch <= 0x230b))
		return (ch - 6755);

	if (ch == 0x2310)
		return 2217;

	if (ch == 0x2318)
		return 2218;

	if ((ch >= 0x231a) && (ch <= 0x231b))
		return (ch - 6767);

	if ((ch >= 0x2320) && (ch <= 0x2321))
		return (ch - 6771);

	if ((ch >= 0x2329) && (ch <= 0x232a))
		return (ch - 6778);

	if ((ch >= 0x239b) && (ch <= 0x23bd))
		return (ch - 6890);

	if (ch == 0x23ce)
		return 2260;

	if ((ch >= 0x2409) && (ch <= 0x240d))
		return (ch - 6964);

	if ((ch >= 0x2423) && (ch <= 0x2424))
		return (ch - 6985);

	if (ch == 0x2426)
		return 2268;

	if ((ch >= 0x2500) && (ch <= 0x2595))
		return (ch - 7203);

	if ((ch >= 0x25a0) && (ch <= 0x25f7))
		return (ch - 7213);

	if ((ch >= 0x2600) && (ch <= 0x2602))
		return (ch - 7221);

	if ((ch >= 0x2605) && (ch <= 0x260d))
		return (ch - 7223);

	if ((ch >= 0x2610) && (ch <= 0x2613))
		return (ch - 7225);

	if (ch == 0x2620)
		return 2523;

	if (ch == 0x2622)
		return 2524;

	if (ch == 0x2626)
		return 2525;

	if ((ch >= 0x2628) && (ch <= 0x262b))
		return (ch - 7242);

	if ((ch >= 0x262e) && (ch <= 0x2637))
		return (ch - 7244);

	if ((ch >= 0x2639) && (ch <= 0x2653))
		return (ch - 7245);

	if ((ch >= 0x2660) && (ch <= 0x2667))
		return (ch - 7257);

	if ((ch >= 0x2669) && (ch <= 0x266f))
		return (ch - 7258);

	if ((ch >= 0xfb00) && (ch <= 0xfb05))
		return (ch - 61674);

	if ((ch >= 0xfb50) && (ch <= 0xfbb1))
		return (ch - 61748);

	if ((ch >= 0xfbd3) && (ch <= 0xfbe9))
		return (ch - 61781);

	if ((ch >= 0xfbfc) && (ch <= 0xfbff))
		return (ch - 61799);

	if ((ch >= 0xfc5b) && (ch <= 0xfc63))
		return (ch - 61890);

	if (ch == 0xfc90)
		return 2722;

	if ((ch >= 0xfcf2) && (ch <= 0xfcf4))
		return (ch - 62031);

	if ((ch >= 0xfd3c) && (ch <= 0xfd3f))
		return (ch - 62102);

	if (ch == 0xfdf2)
		return 2730;

	if ((ch >= 0xfe50) && (ch <= 0xfe52))
		return (ch - 62373);

	if ((ch >= 0xfe54) && (ch <= 0xfe66))
		return (ch - 62374);

	if ((ch >= 0xfe68) && (ch <= 0xfe6b))
		return (ch - 62375);

	if ((ch >= 0xfe70) && (ch <= 0xfe72))
		return (ch - 62379);

	if (ch == 0xfe74)
		return 2760;

	if ((ch >= 0xfe76) && (ch <= 0xfefc))
		return (ch - 62381);

	if (ch == 0xfeff)
		return 2896;

	if (found)
		*found = false;

	return 2898;
}

uint8_t fb_font[FONT_GLYPHS][FONT_SCANLINES] = {
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x7c, 0xc6, 0xc2, 0xc0, 0x7c, 0x06, 0x06, 0x86, 0xc6, 0x7c, 0x18, 0x18, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc2, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xc6, 0x86, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x76, 0xdc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x30, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xd6, 0xd6, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x3c, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x1c, 0x3c, 0x6c, 0xcc, 0xfe, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xfc, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x60, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x06, 0x06, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x0c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xde, 0xde, 0xde, 0xdc, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xde, 0x7c, 0x0c, 0x0e, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x38, 0x7c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x86, 0x0c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0x70, 0x38, 0x1c, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00},
	{0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x1e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x18, 0x3c, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60, 0x60, 0x60, 0xe6, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0xc6, 0x60, 0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x99, 0xa5, 0xa1, 0xa1, 0xa5, 0x99, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x44, 0xba, 0xb2, 0xaa, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xd8, 0x30, 0x60, 0xc8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xd8, 0x30, 0x18, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xf6, 0xc0, 0xc0, 0xc0, 0x00},
	{0x00, 0x00, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x30, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x66, 0xce, 0x9e, 0x3e, 0x06, 0x06, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xdc, 0x86, 0x0c, 0x18, 0x3e, 0x00, 0x00},
	{0x00, 0xe0, 0x30, 0x62, 0x36, 0xec, 0x18, 0x30, 0x66, 0xce, 0x9e, 0x3e, 0x06, 0x06, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x60, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x6c, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x38, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3e, 0x6c, 0xcc, 0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x18, 0x0c, 0x38, 0x00},
	{0x30, 0x18, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x3c, 0x42, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0xf6, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7a, 0xc4, 0xce, 0xce, 0xd6, 0xd6, 0xe6, 0xe6, 0x46, 0xbc, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x6c, 0x66, 0x66, 0x66, 0x66, 0xec, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x30, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x76, 0x36, 0x7e, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0x1c, 0x3c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xc4, 0xce, 0xd6, 0xe6, 0x46, 0xbc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x30, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x7c, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x0c, 0x18, 0x0e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x0c, 0x18, 0x0e, 0x00},
	{0x0c, 0x18, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0xf6, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x3e, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x18, 0x30, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x6c, 0x38, 0x10, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0x3c, 0x66, 0xc2, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x6c, 0x38, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x18, 0x18, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x18, 0x30, 0x30, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x10, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0xe0, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0xff, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0xf8, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7e, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7e, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x66, 0x3c, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x3c, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x30, 0x1c, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x30, 0x1c, 0x00},
	{0x18, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf7, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7b, 0x7b, 0xee, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x00, 0xee, 0x66, 0x66, 0x66, 0x66, 0x66, 0xf6, 0x06, 0x66, 0x3c, 0x00},
	{0x08, 0x1c, 0x22, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x04, 0x0e, 0x1b, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x30, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x30},
	{0x6c, 0x38, 0x10, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x66, 0x66, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0x30, 0x30, 0x30, 0x36, 0x36, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x78, 0xe0, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x1e, 0x78, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x18, 0x18, 0x30},
	{0x6c, 0x38, 0x10, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x60, 0x60, 0xc0, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x66, 0xcc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0xcc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6e, 0xd8, 0xd8, 0xd8, 0xde, 0xd8, 0xd8, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xd6, 0xd6, 0xde, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x18, 0x18, 0x30},
	{0x6c, 0x38, 0x10, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0xc6, 0x7c, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x18, 0x0c, 0x38, 0x00},
	{0x6c, 0x38, 0x10, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x18, 0x0c, 0x38, 0x00},
	{0x6c, 0x38, 0x10, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0x10, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0xfc, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x78, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x78, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x38, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x66, 0xcc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x30, 0x60, 0x38, 0x00},
	{0x10, 0x38, 0x44, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x66, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xfe, 0xc6, 0x8c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x00, 0xfe, 0xc6, 0x8c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0xfe, 0xc6, 0x8c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0xf8, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0xb3, 0xb3, 0x33, 0x3e, 0x33, 0x33, 0x33, 0x33, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x64, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x62, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xe6, 0xe6, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0xe0, 0xe0, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0x86, 0x06, 0x06, 0x06, 0x06, 0x86, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x03, 0x3e, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x03, 0x7e, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0xf6, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xb6, 0xb3, 0x33, 0x33, 0x33, 0x33, 0x33, 0x36, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x4c, 0x0c, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0x4c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x30, 0x18, 0xcc, 0x78, 0x00},
	{0x00, 0x00, 0xfe, 0xcc, 0x8c, 0x2c, 0x3c, 0x2c, 0x0c, 0x8c, 0xcc, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x06, 0xfe, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc2, 0xc0, 0x78, 0xc0, 0xc0, 0xc2, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xc0, 0x00},
	{0x00, 0x00, 0x1c, 0x36, 0x32, 0x30, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xe0, 0x00},
	{0x00, 0x03, 0x3e, 0x66, 0xc2, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x38, 0x6c, 0x38, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xf3, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x6d, 0x6c, 0x78, 0x70, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc8, 0x38, 0x70, 0xd0, 0x38, 0x38, 0x6c, 0x64, 0xc6, 0xc2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0xec, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x76, 0x7e, 0x7e, 0x6e, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0xc0, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x06, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x03, 0x7a, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x06, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x73, 0xdf, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x73, 0x03, 0x03, 0x03, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0xdf, 0xdb, 0xdb, 0xdb, 0xdb, 0x73, 0x03, 0x03, 0x03, 0x00},
	{0x00, 0x00, 0x7e, 0xb3, 0xb3, 0x33, 0x3e, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x7c, 0x66, 0x66, 0x7c, 0x78, 0x6c, 0x6c, 0xe6, 0x06, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x0c, 0x38, 0x60, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x0c, 0x38, 0x60, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x62, 0x30, 0x18, 0x18, 0x30, 0x62, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xd8, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x0e, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x0c, 0x6c, 0x38, 0x00},
	{0x00, 0x00, 0x7e, 0xfe, 0x9a, 0x58, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x36, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00},
	{0x03, 0x03, 0xce, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x06, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xee, 0x6c, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x63, 0xb3, 0xb3, 0x33, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x06, 0x0d, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x18, 0xf0, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x86, 0x0c, 0x7e, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0xfc, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x30, 0x7c, 0x06, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x7c, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x78, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x7c, 0xc0, 0xc6, 0x7c, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x06, 0x0c, 0x7e, 0x30, 0x60, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x60, 0x60, 0x78, 0x0c, 0x06, 0x06, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x60, 0x78, 0x0c, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x18, 0x4c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x6c, 0x78, 0x70, 0x60, 0x60, 0xf0, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x1b, 0x0e, 0x04, 0xf7, 0xd9, 0xd9, 0xda, 0xda, 0xda, 0xdc, 0xdc, 0xf7, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf5, 0xda, 0xd8, 0xdf, 0xd9, 0xda, 0xda, 0xda, 0xdc, 0xf7, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3d, 0x1a, 0x18, 0x7f, 0xd9, 0xda, 0xda, 0xda, 0xdc, 0x6f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc7, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xcb, 0xf6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf3, 0x63, 0x60, 0x67, 0x63, 0x63, 0x63, 0x67, 0x6f, 0xff, 0x03, 0x1b, 0x0e, 0x00},
	{0x00, 0x00, 0xe3, 0x63, 0x60, 0x67, 0x63, 0x63, 0x63, 0x63, 0x63, 0xf3, 0x03, 0x33, 0x1e, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0xfb, 0xfb, 0xfb, 0xdb, 0xdb, 0xdb, 0xdb, 0xde, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0xf8, 0xff, 0xfb, 0xfb, 0xdb, 0xdb, 0xdb, 0xdb, 0x03, 0x33, 0x1e, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x00, 0xb7, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x03, 0x33, 0x1e, 0x00},
	{0x6c, 0x38, 0x10, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x7c, 0x00, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x78, 0x00, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x10, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x30, 0x00, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x28, 0x10, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x78, 0x30, 0x00, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x20, 0x10, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x00, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x7c, 0x00, 0x6c, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x7c, 0x30, 0x30, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0x30, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0x3e, 0x6c, 0xcc, 0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0xcc, 0x76, 0x36, 0x7e, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xde, 0xc6, 0xdf, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x3e, 0xcc, 0x78, 0x00},
	{0x6c, 0x38, 0x10, 0x3c, 0x66, 0xc2, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x6c, 0x38, 0x10, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0xe0, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x6c, 0x38, 0x10, 0xfe, 0x0c, 0x18, 0x30, 0x7c, 0x06, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00},
	{0x00, 0x1b, 0x0e, 0x04, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00},
	{0x00, 0x00, 0xf7, 0xd9, 0xd9, 0xda, 0xda, 0xda, 0xda, 0xdc, 0xdc, 0xf7, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0xd8, 0xd8, 0xdf, 0xd9, 0xda, 0xda, 0xda, 0xdc, 0xf7, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x7f, 0xd9, 0xda, 0xda, 0xda, 0xdc, 0x6f, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x30, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x00, 0x00, 0xd8, 0xd8, 0xd8, 0xdb, 0xfb, 0xdb, 0xdb, 0xdb, 0xdb, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x66, 0x6c, 0x78, 0x70, 0x60, 0x60, 0x60, 0x60, 0xe0, 0x00},
	{0x60, 0x30, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x18, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x38, 0x6c, 0x38, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x38, 0x6c, 0x38, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x3e, 0x6c, 0xcc, 0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xcc, 0x76, 0x36, 0x7e, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x7a, 0xc4, 0xce, 0xce, 0xd6, 0xe6, 0xe6, 0x46, 0xbc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7a, 0xc4, 0xce, 0xd6, 0xe6, 0x46, 0xbc, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0x66, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x66, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0x66, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x66, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x3c, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0x66, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x66, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0x66, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x66, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0x66, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x66, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x18, 0x18, 0x30},
	{0x00, 0x00, 0x7c, 0xc6, 0x86, 0x06, 0x1c, 0x74, 0x06, 0x06, 0x06, 0x06, 0x1c, 0xf0, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x0e, 0x3c, 0x06, 0x06, 0x1c, 0xf0, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0xe0, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x86, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0xfc, 0x06, 0x0c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc0, 0xfc, 0x06, 0x0c, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x18, 0x0c, 0x38, 0x00},
	{0x7c, 0x00, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x7c, 0x00, 0x72, 0x9c, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x7c, 0x00, 0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x7c, 0x00, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x3c, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x5c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xdc, 0xe6, 0x7c, 0x80, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0d, 0x06, 0x00},
	{0x00, 0x00, 0x06, 0x0d, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x6c, 0x8e, 0x16, 0x26, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0x78, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xcd, 0x0d, 0x38, 0x0c, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xdc, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x06, 0x06, 0x1f, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00},
	{0x00, 0x00, 0x00, 0x06, 0x0d, 0x7c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xce, 0xc6, 0xc6, 0x7a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x46, 0x6c, 0x2c, 0x2c, 0x38, 0x18, 0x18, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x64, 0x28, 0x38, 0x38, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xcc, 0xcc, 0xcc, 0xcc, 0xdc, 0x6c, 0x0c, 0x0c, 0x0e, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3c, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x7b, 0xde, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x78, 0x58, 0x3e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x0e, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x7f, 0x63, 0x66, 0x6c, 0x7e, 0x63, 0xf3, 0x03, 0x33, 0x1e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6e, 0x06, 0x06, 0x06, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0xc0, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x03, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xd8, 0xd8, 0xde, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0xcc, 0xdc, 0x6c, 0x0c, 0x0d, 0x06, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0x60, 0x60, 0x6c, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xcc, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x66, 0x6c, 0x7c, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0xfc, 0xc0, 0xd8, 0x70, 0x00},
	{0x00, 0x00, 0x0e, 0x1b, 0x19, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x98, 0xd8, 0x70, 0x00},
	{0x00, 0x00, 0x0e, 0x1b, 0x19, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x98, 0xd8, 0x70, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0xd8, 0x18, 0x18, 0x18, 0x18, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0xd8, 0x70, 0x00},
	{0x00, 0x00, 0x70, 0xd8, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0xff, 0x66, 0x66, 0x3b, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xd6, 0xd6, 0xd6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3e, 0x60, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x06, 0x06, 0x03, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x66, 0xcb, 0xfe, 0x10, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x06, 0x7e, 0xc7, 0x7c, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0x70, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc3, 0xc3, 0xdb, 0xdb, 0xc3, 0xc3, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0x66, 0x7c, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x76, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x03, 0x7e, 0xc6, 0xc0, 0xce, 0xc6, 0xc6, 0x7a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x0c, 0x00, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7e, 0xcc, 0x78, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xcc, 0x6c, 0x3c, 0x3c, 0x6c, 0xcc, 0x0c, 0x0c, 0x0e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x06, 0x0d, 0x7c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x1e, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x1c, 0x18, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0x70, 0x30, 0xfc, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x7f, 0xd9, 0xda, 0xda, 0xda, 0xdc, 0x6f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x7f, 0xdb, 0xdb, 0xde, 0xde, 0xdb, 0x6b, 0x03, 0x1b, 0x0e, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x7f, 0xd9, 0xda, 0xda, 0xdb, 0xdd, 0x6f, 0x04, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x60, 0x60, 0xf6, 0x6d, 0x6c, 0x66, 0x63, 0x6b, 0x36, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x26, 0x6d, 0x6c, 0xfc, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x3c, 0x0c, 0x2c, 0x18, 0x00},
	{0x00, 0x00, 0x20, 0x60, 0x60, 0xf6, 0x6d, 0x6c, 0x6c, 0x6e, 0x6d, 0x36, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xd8, 0xc0, 0xfe, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x03, 0x03, 0x0e, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x6d, 0x6c, 0x66, 0x63, 0x6b, 0xf6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x6f, 0x6b, 0x63, 0x66, 0x6c, 0x6d, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xd6, 0x7c, 0x6c, 0x28, 0xc6, 0xd6, 0x7c, 0x6c, 0x28, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xf0, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xc0, 0xf0, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x00, 0x38, 0x18, 0x18, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xb0, 0xd8, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x18, 0xd8, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x18, 0xd8, 0x68, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xd8, 0xd8, 0xf0, 0xd8, 0xd8, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc6, 0xd6, 0x7c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xd8, 0xd8, 0x78, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xd8, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xd8, 0xc0, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x70, 0xc0, 0x70, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0x70, 0x18, 0x70, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x20, 0x20, 0x70, 0x70, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xd8, 0xd8, 0x70, 0x70, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x1c, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x6c, 0x6c, 0x6c, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x34, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00},
	{0xc0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x34, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x3e, 0x32, 0x30, 0x34, 0x3c, 0x34, 0x30, 0x30, 0x32, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x33, 0x33, 0x33, 0x33, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x3e, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x36, 0x36, 0x77, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x6c, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x86, 0x0c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x82, 0x44, 0x7c, 0x44, 0x00, 0x82, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x62, 0x30, 0x18, 0x18, 0x30, 0x62, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x38, 0x7c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x92, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00},
	{0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x66, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc0, 0x78, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x06, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x6c, 0x00, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x6c, 0x60, 0x60, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x46, 0x6c, 0x2c, 0x2c, 0x38, 0x18, 0x18, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x30, 0x18, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0x78, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x46, 0x7c, 0x18, 0x30, 0x60, 0x60, 0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x06, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0x20, 0x30, 0x10, 0x38, 0x38, 0x6c, 0x64, 0xc6, 0xc2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xf6, 0xc0, 0xc0, 0xc0, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x66, 0x6c, 0x3c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x3c, 0x30, 0x60, 0x3c, 0x60, 0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x46, 0x2c, 0x2c, 0x18, 0x30, 0x68, 0x68, 0xc4, 0xc2, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x6c, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x36, 0x1e, 0xc6, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc2, 0x65, 0x24, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0xc0, 0x21, 0x32, 0x12, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xc2, 0x65, 0x24, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xa6, 0x2c, 0x38, 0x68, 0xca, 0xc4, 0x0c, 0x18, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0x60, 0x3c, 0x06, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x78, 0x68, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x32, 0x30, 0x30, 0x3c, 0x34, 0x30, 0x30, 0x30, 0x30, 0x00},
	{0x00, 0x60, 0x30, 0x30, 0x60, 0x63, 0xff, 0xc6, 0x06, 0x0c, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x60, 0x60, 0xfe, 0xfe, 0x0c, 0x0c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xac, 0x26, 0x26, 0x0b, 0x0b, 0x1b, 0x1b, 0x1b, 0x1b, 0x03, 0x02, 0x04, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc0, 0x60, 0x30, 0x18, 0x28, 0x4c, 0x14, 0x24, 0x06, 0x02, 0x02, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x6d, 0x03, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x6d, 0x03, 0x7e, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xd6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x36, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x76, 0x9c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x7c, 0xd6, 0x66, 0x06, 0x06, 0x66, 0xbc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x3c, 0x60, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x26, 0x1c, 0x70, 0xc0, 0xc2, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0x68, 0x38, 0x30, 0x38, 0x38, 0x4c, 0x4c, 0x86, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xba, 0x30, 0x38, 0x28, 0x4c, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0xc0, 0xcc, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xdc, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x7e, 0x99, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x1c, 0x18, 0x7e, 0x58, 0x18, 0x18, 0x18, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xa6, 0x2c, 0x38, 0x68, 0xca, 0xc4, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0x60, 0x3c, 0x06, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00},
	{0x30, 0x18, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xb2, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x03, 0x06, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xf8, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xd8, 0xd8, 0xd8, 0xde, 0xdb, 0xdb, 0xdb, 0xdb, 0xde, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xd8, 0xd8, 0xd8, 0xd8, 0xfe, 0xdb, 0xdb, 0xdb, 0xdb, 0xde, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xb2, 0x30, 0x3e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x18, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x38, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xfe, 0xc6, 0x82, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x86, 0x06, 0x3c, 0x06, 0x06, 0x86, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x38, 0x7c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xfe, 0x06, 0x02, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xff, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0xb0, 0xb0, 0x30, 0x3c, 0x36, 0x36, 0x36, 0x36, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xf3, 0xdb, 0xdb, 0xdb, 0xdb, 0xf3, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0x86, 0x06, 0x3e, 0x06, 0x06, 0x86, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x9c, 0xb6, 0xb6, 0xb6, 0xf6, 0xb6, 0xb6, 0xb6, 0xb6, 0x9c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0xcc, 0xcc, 0xcc, 0x7c, 0x6c, 0x6c, 0x6c, 0x6c, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0x66, 0x7c, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xfe, 0xc6, 0x82, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xfe, 0x06, 0x02, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xff, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xb0, 0x30, 0x3c, 0x36, 0x36, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xf3, 0xdb, 0xdb, 0xf3, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3e, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xb6, 0xb6, 0xf6, 0xb6, 0xb6, 0x9c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xcc, 0xcc, 0x7c, 0x6c, 0x6c, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0xf8, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x06, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xf8, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xd8, 0xd8, 0xde, 0xdb, 0xdb, 0xde, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xd8, 0xd8, 0xfe, 0xdb, 0xdb, 0xde, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0xf8, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xe6, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x38, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x6c, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0xfc, 0xb4, 0x30, 0x3c, 0x36, 0x36, 0x36, 0x36, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0xb4, 0x30, 0x3c, 0x36, 0x36, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xce, 0xdb, 0xd9, 0xd8, 0xfe, 0xd8, 0xd8, 0xd9, 0xdb, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xce, 0xdb, 0xd8, 0xfe, 0xd8, 0xdb, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0x6c, 0xfe, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x6c, 0x7c, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x88, 0x8c, 0x9c, 0x96, 0xf6, 0xb6, 0xbf, 0xab, 0xeb, 0xeb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x8c, 0x9c, 0xf6, 0xbe, 0xab, 0xeb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x6c, 0x6c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0x6c, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0xa3, 0xb2, 0x96, 0xfc, 0x9c, 0xbe, 0xaa, 0xab, 0xeb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xa3, 0x96, 0xfe, 0xab, 0xab, 0xeb, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x10, 0x7c, 0xc6, 0x06, 0x06, 0x7c, 0x06, 0x06, 0x06, 0x7c, 0xc0, 0x7c, 0x00, 0x00},
	{0x00, 0x6c, 0x38, 0x10, 0x00, 0x7c, 0x86, 0x06, 0x7c, 0x06, 0x06, 0x7c, 0xc0, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x96, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x10, 0x96, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc2, 0xc6, 0xc6, 0xc4, 0xcc, 0x6c, 0x68, 0x78, 0x38, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xc6, 0x64, 0x6c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0x66, 0x00, 0xc2, 0xc6, 0xc4, 0xc4, 0x6c, 0x68, 0x78, 0x38, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0x66, 0x00, 0xc2, 0xc6, 0x64, 0x6c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xd8, 0xd8, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x6f, 0x03, 0x06, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x6f, 0x03, 0x06, 0x1c, 0x00},
	{0x00, 0x10, 0x7c, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6, 0xc6, 0xc6, 0xc6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00},
	{0x04, 0x7c, 0x40, 0x6c, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x04, 0x7c, 0x40, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x7c, 0x54, 0x00, 0x6c, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0x54, 0x00, 0x6c, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x60, 0x3c, 0x0c, 0x0c, 0x0c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0x78, 0x18, 0x18, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x06, 0x3c, 0x0f, 0x18, 0x18, 0xf0, 0x3c, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x04, 0x7c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x24, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x40, 0x7c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x04, 0x7c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x66, 0x00, 0xc3, 0x00, 0x66, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x50, 0x46, 0x00, 0x82, 0x41, 0x00, 0x62, 0x0a, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x60, 0xf0, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x60, 0xf0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x6e, 0x64, 0x7a, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x6e, 0x64, 0x7a, 0x60, 0x60, 0xf0, 0x00},
	{0x02, 0x06, 0xfe, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x02, 0x06, 0xfe, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x60, 0xf8, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x66, 0x62, 0xf8, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xf6, 0x06, 0x16, 0x0c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x66, 0x62, 0x78, 0x6c, 0x66, 0xf6, 0x06, 0x16, 0x0c, 0x00},
	{0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0xd6, 0xd6, 0xd7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x86, 0x06, 0x3c, 0x06, 0x06, 0x86, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x30, 0x60, 0x38, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xd6, 0xd6, 0xdc, 0xf8, 0xdc, 0xd6, 0xd6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xdc, 0xf8, 0xdc, 0xd6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0xf6, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0xf0, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf3, 0xb3, 0xb3, 0x36, 0x3c, 0x3c, 0x36, 0x33, 0x33, 0x73, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf3, 0xb6, 0xbc, 0x3c, 0x36, 0x33, 0x73, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xdf, 0xdb, 0xd9, 0xd8, 0xf8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xdb, 0xd9, 0xf8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0xd8, 0xd8, 0xd8, 0xde, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x03, 0x0b, 0x06, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xd8, 0xd8, 0xfe, 0xdb, 0xdb, 0xdb, 0x03, 0x0b, 0x06, 0x00},
	{0x00, 0x00, 0x7c, 0xc2, 0xcc, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xcc, 0x7a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc2, 0xcc, 0xd6, 0xd6, 0xcc, 0x7a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x0c, 0x04, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x0c, 0x04, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x3c, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x38, 0x7c, 0x6c, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xf6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7f, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7f, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x07, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x07, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0x7e, 0x16, 0x16, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xd6, 0x7e, 0x16, 0x16, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x33, 0xb3, 0xb3, 0x7f, 0x30, 0x30, 0x30, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xb3, 0x7f, 0x30, 0x30, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x33, 0xb3, 0xb3, 0x7f, 0x30, 0x30, 0x30, 0x33, 0x1e, 0x0c, 0x18, 0x0e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xb3, 0x7f, 0x30, 0x30, 0x33, 0x1e, 0x0c, 0x18, 0x0e, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x06, 0x16, 0x0c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x06, 0x16, 0x0c, 0x00},
	{0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x16, 0x0c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x06, 0x16, 0x0c, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x0e, 0x0c, 0x08, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x0e, 0x0c, 0x08, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc7, 0x03, 0x01, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3e, 0x6c, 0xcc, 0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x76, 0x36, 0x7e, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x06, 0xfe, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x86, 0x06, 0x3c, 0x06, 0x86, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x06, 0x86, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00},
	{0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xce, 0xde, 0xfe, 0xf6, 0xe6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x78, 0xcc, 0x86, 0x06, 0x3e, 0x06, 0x86, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x3e, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x66, 0xcc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0xcc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xc3, 0xc3, 0xc3, 0xf3, 0xdb, 0xdb, 0xdb, 0xdb, 0xf3, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc3, 0xc3, 0xc3, 0xf3, 0xdb, 0xdb, 0xf3, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x7c, 0xcd, 0xcd, 0xcd, 0xcd, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcd, 0xcd, 0xcd, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0x8c, 0x0c, 0x38, 0x0d, 0x0d, 0x0d, 0x0d, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0x0c, 0x39, 0x0d, 0x0d, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0x86, 0x06, 0x3c, 0x06, 0x06, 0x06, 0x06, 0x07, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0x06, 0x07, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6d, 0x6d, 0x6d, 0x6d, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x6c, 0x6c, 0x6d, 0x6d, 0x6d, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xfc, 0xcd, 0xcd, 0xcd, 0xcd, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xfd, 0xcd, 0xcd, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xce, 0xc6, 0xc6, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xce, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x1b, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x5a, 0x18, 0x1b, 0x1b, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x64, 0x94, 0xba, 0x52, 0x4c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcf, 0x7b, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x7e, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x7f, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcf, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x7e, 0x60, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x0c, 0xd8, 0xfe, 0xc3, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x06, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xcf, 0xd6, 0xd6, 0xd6, 0xd6, 0xcc, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x7f, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x06, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xf6, 0xd6, 0xd6, 0xd6, 0xd6, 0xcc, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0x7f, 0x24, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0xf0, 0x3c, 0x0e, 0x04, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x06, 0x06, 0x06, 0x6c, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x0c, 0x0c, 0x0c, 0x0f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x30, 0x60, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcf, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x06, 0x06, 0x7c, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x06, 0x3e, 0x66, 0x60, 0x60, 0x60, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x06, 0x06, 0x06, 0x6c, 0x38, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x16, 0x16, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x76, 0x1e, 0x0e, 0x0c, 0xd8, 0xfe, 0xc3, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcf, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x0f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x30, 0x18, 0x0c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x06, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x63, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xfe, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xd0, 0xd0, 0xd0, 0x7c, 0x16, 0x16, 0x16, 0xd6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x06, 0x3c, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x1c, 0x36, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x6a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x60, 0x60, 0x7e, 0x60, 0x60, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7f, 0x0c, 0x0c, 0x0c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcf, 0x0c, 0x0c, 0x0c, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x7e, 0x60, 0x60, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x0f, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78, 0x0c, 0x18, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x7e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xcf, 0xd6, 0xd6, 0xcc, 0xc0, 0xc0, 0xc0, 0x00},
	{0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x7f, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3e, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xf6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xca, 0xc0, 0xc0, 0xc0, 0x00},
	{0x00, 0x00, 0x60, 0x38, 0x0c, 0x7f, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x06, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x1c, 0x0c, 0x18, 0x3c, 0x64, 0x66, 0x62, 0x63, 0x3d, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x0c, 0x0c, 0x0f, 0x00},
	{0x00, 0x00, 0x0e, 0x18, 0x30, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0f, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x6c, 0x38, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x3e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x3e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7e, 0x06, 0x06, 0x06, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x76, 0x1c, 0x18, 0x30, 0x60, 0x3e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcf, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x0f, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x66, 0x3c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x10, 0xdc, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x76, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0xfe, 0x60, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xd0, 0xd0, 0x7c, 0x16, 0x16, 0x16, 0x16, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xcc, 0xcc, 0xcc, 0x77, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x6c},
	{0x18, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x38, 0x10, 0x38, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x60, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x0c, 0x00},
	{0x10, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x74, 0xd6, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xc0, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x03, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x18, 0x30, 0x00},
	{0x0c, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1b, 0x36, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x44, 0xaa, 0x6c, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x0a, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x40, 0x50, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x3c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x6c, 0xd8, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x08, 0x30},
	{0x60, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x40, 0xa0, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x10, 0x10},
	{0x18, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x03, 0x00},
	{0x48, 0xa8, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0x00, 0x33, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x00, 0x06, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x60, 0x66, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18},
	{0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x18, 0x03, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x7e, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x66, 0x76, 0xdc, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x0c, 0x0c, 0x0c, 0x1c, 0x36, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xcc, 0xd6, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0xc6, 0xc6, 0xc6, 0xc6, 0xde, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0xc6, 0xc6, 0xc6, 0xc6, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xee, 0x66, 0x66, 0x66, 0x66, 0x66, 0x2c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xf8, 0x4c, 0xcc, 0xcc, 0xec, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0e, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x46, 0xc6, 0xc6, 0xe6, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xee, 0x66, 0x66, 0x6c, 0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xee, 0x66, 0x66, 0x34, 0x18, 0x0c, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x66, 0x64, 0x6c, 0x6e, 0x60, 0x60, 0x60, 0x60, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xf6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe6, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xcc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xcc, 0x66, 0x66, 0x66, 0xc6, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xcc, 0x66, 0x66, 0x66, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x22, 0x20, 0x10, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x1e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x02, 0x3c, 0x40, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x20, 0x1c, 0x20, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x1c, 0x20, 0x1c, 0x20, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x18, 0x20, 0x1c, 0x20, 0x00, 0x00},
	{0x00, 0x30, 0x40, 0x38, 0x40, 0x07, 0x08, 0x88, 0x86, 0x81, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x28, 0x00, 0x00, 0x18, 0x24, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x14, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x88, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x20, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x15, 0x88, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x01, 0x15, 0x88, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x20, 0x20, 0x2c, 0x32, 0xa2, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x20, 0x20, 0x2c, 0x32, 0xa2, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x80, 0x8c, 0x70, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x40, 0x00, 0x00, 0x70, 0x80, 0x8c, 0x70, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0a, 0x00, 0x06, 0x09, 0x09, 0x47, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x19, 0x21, 0x19, 0x21, 0x01, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42, 0x82, 0x82, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x3c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x40, 0x30, 0x4e, 0x49, 0x39, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x24, 0x00},
	{0x0c, 0x30, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x12, 0xca, 0x2c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x0c, 0x30, 0x00, 0x00},
	{0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x14, 0x0c, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00},
	{0x0a, 0x2a, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x01, 0x7e, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x10, 0x0c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10, 0x0c, 0x10},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x78, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x70, 0x70, 0x38, 0x18, 0x18, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x44, 0xfc, 0xf8, 0x60, 0x30, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x4a, 0xfe, 0xf4, 0x60, 0x30, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x20, 0x40, 0x30, 0x10, 0x20, 0x42, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x2c, 0x44, 0x42, 0x82, 0x82, 0xfe, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x80, 0xf8, 0x78, 0x08, 0x08, 0x08, 0x0c, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x82, 0xc6, 0xc6, 0x6c, 0x28, 0x38, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x28, 0x6c, 0xc6, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xf8, 0x88, 0xf8, 0x78, 0x08, 0x0c, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x91, 0x92, 0x64, 0x08, 0x10, 0x26, 0x49, 0x89, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x18, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0xfe, 0x7c, 0x38, 0x6c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x06, 0x29, 0x5e, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x06, 0x28, 0x5e, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x06, 0x28, 0x5e, 0x00, 0x00, 0x00},
	{0x00, 0x07, 0x08, 0x07, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x04, 0x03, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x04, 0x03, 0x04, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x23, 0x54, 0x33, 0x24, 0x40, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x04, 0x03, 0x04, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x08, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x14, 0x40, 0x81, 0x81, 0x7e, 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x08, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x14, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00},
	{0x06, 0x08, 0x06, 0x08, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x08, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x94, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x88, 0x80, 0x88, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x94, 0x80, 0x88, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x94, 0x80, 0x94, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x20, 0x38, 0x28, 0x70, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x08, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x20, 0x38, 0x28, 0x70, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x14, 0x00, 0x08, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x14, 0x00, 0x14, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x08, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x1c, 0x6a, 0x04, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x14, 0x08, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x12, 0x04, 0x18, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x14, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x14, 0x00, 0x14, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x00, 0x01, 0x15, 0x88, 0x88, 0x8a, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x15, 0x88, 0x88, 0x90, 0x65, 0x00, 0x02, 0x00, 0x00, 0x00},
	{0x00, 0x04, 0x00, 0x0a, 0x00, 0x01, 0x15, 0x88, 0x88, 0x90, 0x65, 0x00, 0x02, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x90, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x00, 0x0a, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x00, 0x2a, 0x20, 0x20, 0x2c, 0x32, 0xa2, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x20, 0x00, 0x50, 0x00, 0x70, 0x80, 0x8c, 0x70, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x00, 0x0a, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x0a, 0x00, 0x04, 0x00, 0x00, 0x00},
	{0x0a, 0x00, 0x0a, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x09, 0x09, 0x47, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x04, 0x00, 0x0a, 0x00, 0x06, 0x09, 0x09, 0x47, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x00, 0x01, 0x02, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x20, 0x40, 0x3e, 0x01, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x01, 0x02, 0x05, 0x0b, 0x48, 0x84, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x00, 0x19, 0x21, 0x19, 0x21, 0x01, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x00, 0x29, 0x01, 0x19, 0x21, 0x19, 0xa1, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x19, 0x21, 0x19, 0x21, 0x01, 0x81, 0x7e, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x05, 0x0b, 0x48, 0x84, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xa4, 0x09, 0x12, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x44, 0x09, 0xa2, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x14, 0x08, 0x02, 0x02, 0x02, 0x02, 0x42, 0x82, 0x82, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42, 0x82, 0x82, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x02, 0x2a, 0x02, 0x02, 0x02, 0x42, 0x82, 0x82, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42, 0x82, 0x82, 0x84, 0x78, 0x00, 0x14, 0x00, 0x08, 0x00},
	{0x00, 0x08, 0x00, 0x00, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x04, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x08, 0x14, 0x08, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x38, 0x4c, 0x52, 0x32, 0x3c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x94, 0x80, 0x88, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x38, 0x40, 0x38, 0x40, 0x18, 0x24, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x40, 0x38, 0x40, 0x00, 0x0c, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x0c, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x12, 0x2c, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x3c, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x08, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x28, 0x18, 0x10, 0x20, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x08, 0x08, 0x08, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x14, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x14, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x20, 0x47, 0x88, 0x08, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x50, 0x20, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x82, 0x7c, 0x00, 0x08, 0x00, 0x08},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x82, 0x7c, 0x00, 0x14, 0x00, 0x08},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x60, 0x80, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x80, 0x60, 0x80, 0x08, 0x14, 0x60, 0x80, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x40, 0x40, 0x43, 0x55, 0x7e, 0x80, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x2a, 0x20, 0x26, 0x2a, 0x7c, 0x80, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x0e, 0x1c, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x14, 0x14, 0x08, 0x14, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x2c, 0x10, 0x28, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x15, 0x8a, 0x90, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x5a, 0xa5, 0x66, 0x5b, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x5a, 0x66, 0xa5, 0x5a, 0x00},
	{0x00, 0x00, 0x18, 0x66, 0x42, 0x42, 0x81, 0x99, 0x99, 0x81, 0x42, 0x42, 0x66, 0x18, 0x00, 0x00},
	{0x08, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x26, 0x08, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x0c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x8a, 0x90, 0x60},
	{0x32, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x0c, 0x04, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x30, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x30, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x28, 0x54, 0xaa, 0x92, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x82, 0xfe, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x14, 0x08},
	{0x08, 0x14, 0x22, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x10, 0x10, 0x10},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x70, 0x70, 0x38, 0x18, 0x18, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x44, 0xfc, 0xf8, 0x60, 0x30, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x4a, 0xfe, 0xf4, 0x60, 0x30, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x4e, 0xf0, 0xfe, 0x7c, 0x30, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x38, 0x2c, 0x44, 0x42, 0x82, 0x92, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x60, 0x7e, 0x3c, 0x30, 0x60, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x82, 0xc6, 0xc6, 0x6c, 0x28, 0x38, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x28, 0x6c, 0xc6, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xf8, 0x88, 0xf8, 0x78, 0x08, 0x0c, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x01, 0x15, 0x88, 0x88, 0x88, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x40, 0x00, 0x00, 0x70, 0x80, 0x8c, 0x70, 0x40, 0x80, 0x88, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x1e, 0x20, 0x00, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x3c, 0x40, 0x54, 0x54, 0x54, 0x54, 0x40, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x4c, 0x30, 0x4c, 0x02, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x64, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xaa, 0xaa, 0xaa, 0x82, 0x82, 0x40, 0x30, 0x4c, 0x02, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x82, 0x82, 0x44, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x92, 0x92, 0x82, 0x82, 0x40, 0x30, 0x4c, 0x02, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x38, 0x6c, 0x38},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x38, 0x6c, 0x38},
	{0x18, 0x18, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x0c, 0xec, 0x60, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x7c, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x18, 0x0c, 0x38, 0x00},
	{0x30, 0x30, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x60, 0x0c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x30, 0x18, 0x70, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x30, 0x18, 0x70, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x10, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x10, 0x38, 0x6c, 0x00},
	{0x60, 0x30, 0x00, 0x7c, 0x00, 0xfe, 0x62, 0x68, 0x78, 0x68, 0x62, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x7c, 0x00, 0xfe, 0x62, 0x68, 0x78, 0x68, 0x62, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x10, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x10, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x76, 0xdc, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x76, 0xdc, 0x00},
	{0x6c, 0x38, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x18, 0x0c, 0x38, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x18, 0x0c, 0x38, 0x00},
	{0x18, 0x18, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0x38, 0x6c, 0x64, 0xf0, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00},
	{0x30, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x0c, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x00},
	{0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xe0, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x60, 0x30, 0xe0, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x30, 0x18, 0x70, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x6c, 0x38, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x6c, 0x38, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x76, 0xdc, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x76, 0xdc, 0x00},
	{0x0c, 0x18, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x66, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x0c, 0xec, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x7c, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x7c, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x7e, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x10, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x10, 0x38, 0x6c, 0x00},
	{0x0c, 0x18, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x00, 0x30, 0x30, 0x00},
	{0x30, 0x30, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x10, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x10, 0x38, 0x6c, 0x00},
	{0x0c, 0x18, 0x72, 0x9c, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x00, 0x72, 0x9c, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x00, 0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00},
	{0x18, 0x18, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00},
	{0x18, 0x18, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x7c, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x7c, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x60, 0x6c, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0x70, 0x1c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x60, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x44, 0x38, 0x10, 0x7c, 0xc6, 0xc6, 0x70, 0x1c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x30, 0x44, 0x38, 0x10, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x18, 0x18, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x06, 0x16, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x7e, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x7e, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x10, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x08, 0x1c, 0x36, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x6c, 0x6c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x6c, 0x6c, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x76, 0xdc, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x76, 0xdc, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x10, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x10, 0x38, 0x6c, 0x00},
	{0x0c, 0x18, 0x72, 0x9c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x76, 0xdc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0xcc, 0xcc, 0x00, 0xfc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00, 0x18, 0x18, 0x00},
	{0x60, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x18, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0xee, 0x6c, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x30, 0x30, 0x00},
	{0x30, 0x30, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x7c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x7c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x10, 0x38, 0x44, 0xfe, 0xc6, 0x8c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x86, 0x0c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0x86, 0x0c, 0x18, 0x30, 0x60, 0xc2, 0xc6, 0xfe, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x7c, 0x00, 0x00},
	{0x6c, 0x6c, 0x00, 0x10, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x6c, 0x38, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x18, 0x0c, 0x18, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x30, 0x00, 0x38, 0x6c, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x30, 0x30, 0x00},
	{0x38, 0x0c, 0x18, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x0c, 0x18, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x16, 0x38, 0x6c, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x16, 0x38, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0xc0, 0x68, 0x1c, 0x36, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0xc0, 0x68, 0x1c, 0x36, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x0e, 0x13, 0x3a, 0x6c, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x0e, 0x13, 0x3a, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x10, 0x28, 0x54, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x10, 0x38, 0x44, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x6c, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x30, 0x30, 0x00},
	{0x0c, 0x18, 0x44, 0x38, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x18, 0x44, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x44, 0x38, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x30, 0x44, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x08, 0x54, 0x38, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x08, 0x54, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x72, 0x9c, 0x44, 0x38, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x72, 0x9c, 0x44, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x6c, 0x38, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x38, 0x0c, 0x18, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x23, 0x76, 0x88, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x26, 0x70, 0xd8, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0xc4, 0x6e, 0x11, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0xc0, 0x64, 0x0e, 0x1b, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0e, 0x13, 0x3a, 0x6c, 0x00, 0xfe, 0x62, 0x68, 0x78, 0x68, 0x62, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x0e, 0x13, 0x3a, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x10, 0x38, 0x44, 0xfe, 0x62, 0x68, 0x78, 0x68, 0x62, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x10, 0x38, 0x44, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xfe, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x38, 0x0c, 0x18, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x0c, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x38, 0x0c, 0x18, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x0c, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x23, 0x76, 0x88, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x26, 0x70, 0xd8, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0xc4, 0x6e, 0x11, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0xc0, 0x64, 0x0e, 0x1b, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0e, 0x13, 0x3a, 0x44, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0e, 0x13, 0x3a, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x10, 0x28, 0x44, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x76, 0xdc, 0x10, 0x38, 0x44, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x38, 0x44, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x18, 0x33, 0x03, 0x7a, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1b, 0x33, 0x06, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x33, 0x03, 0x7a, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x63, 0x33, 0x06, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x70, 0x1b, 0x33, 0x7a, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0x1b, 0x33, 0x06, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x68, 0xb3, 0x03, 0x7a, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x68, 0xb3, 0x03, 0x06, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x03, 0x7a, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x06, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x30, 0x30, 0x00},
	{0x38, 0x0c, 0x18, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0x18, 0x30, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x33, 0x03, 0xce, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1b, 0x33, 0x06, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x33, 0x03, 0xce, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x63, 0x33, 0x06, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x70, 0x1b, 0x33, 0xce, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0x1b, 0x33, 0x06, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x68, 0xb3, 0x03, 0xce, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x68, 0xb3, 0x03, 0x06, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x03, 0x03, 0xce, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x30, 0x30, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x06, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x30, 0x30, 0x00},
	{0x30, 0x18, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x0c, 0x18, 0xf6, 0x06, 0x00},
	{0x38, 0x0c, 0x18, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x38, 0x0c, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x3a, 0x5c, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00},
	{0x00, 0x18, 0x18, 0x30, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x30, 0x18, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x60, 0x6c, 0xc6, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xc0, 0xcc, 0x66, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x60, 0x66, 0xcc, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xc0, 0xc6, 0x6c, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x34, 0x58, 0x0c, 0x18, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x34, 0x58, 0x30, 0x18, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0xfe, 0x00, 0xa4, 0xaa, 0xea, 0xea, 0xa6, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xa4, 0xea, 0xaa, 0xaa, 0xa6, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xea, 0x8a, 0xce, 0x8e, 0xea, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xea, 0x8e, 0xca, 0x8a, 0xea, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xca, 0x2e, 0x4a, 0x2a, 0xca, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xaa, 0xae, 0xea, 0x2a, 0x2a, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0x6a, 0x8e, 0xca, 0xaa, 0x4a, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0x38, 0x20, 0x30, 0x20, 0x20, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0x30, 0x28, 0x30, 0x20, 0x20, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xea, 0x4a, 0x4e, 0x4a, 0x4a, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0x28, 0x28, 0x38, 0x28, 0x28, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xea, 0x2a, 0x4e, 0x8e, 0xee, 0x00, 0x6c, 0x8a, 0x4c, 0x28, 0xc8, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xea, 0x2a, 0x4e, 0x8e, 0xee, 0x00, 0xa2, 0xa2, 0xe2, 0xea, 0xa4, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xea, 0x2a, 0x4e, 0x8e, 0xee, 0x00, 0x08, 0x08, 0x08, 0x28, 0x10, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0x80, 0x80, 0x80, 0xf0, 0x28, 0x30, 0x28, 0x0a, 0x0e, 0x0e, 0x0a, 0x00, 0xfe, 0x00},
	{0xfe, 0x00, 0xc0, 0xa0, 0xc0, 0xa0, 0x20, 0x20, 0x38, 0x0a, 0x0e, 0x0e, 0x0a, 0x00, 0xfe, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x9c, 0xd2, 0xbc, 0x92, 0x9c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe, 0x00},
	{0x00, 0x18, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00},
	{0x00, 0x30, 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x66, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x66, 0x66, 0x66, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0xcc, 0x00, 0x00},
	{0x00, 0xcc, 0xcc, 0xcc, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x38, 0x3c, 0x38, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x6b, 0x6b, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x92, 0x44, 0x28, 0x92, 0x28, 0x44, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0xc3, 0xdb, 0x1b, 0x1e, 0x1c, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x7c, 0x00, 0x00},
	{0x7c, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x38, 0x6c, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x38, 0x28, 0x00, 0x00, 0x44, 0xee, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7b, 0xcf, 0xcf, 0x1b, 0x33, 0x33, 0x33, 0x00, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xde, 0xf3, 0xf3, 0xc6, 0xcc, 0xcc, 0xcc, 0x00, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x06, 0x06, 0x0c, 0x0c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xdb, 0xdb, 0xdb, 0xde, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x3e, 0x72, 0xf2, 0xf2, 0xf2, 0x72, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xf8, 0x9c, 0x9e, 0x9e, 0x9e, 0x9c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xd8, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x18, 0x38, 0x78, 0xd8, 0xfc, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xf8, 0xc0, 0xf0, 0x18, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x78, 0xc0, 0xf0, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xf8, 0xd8, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xd8, 0x70, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xd8, 0xd8, 0x78, 0x18, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x60, 0x60, 0x60, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x60, 0x30, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xb0, 0xd8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xd8, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xd8, 0x30, 0x60, 0xc8, 0xf8, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xd8, 0x30, 0x18, 0xd8, 0x70, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x38, 0x78, 0xd8, 0xfc, 0x18, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xc0, 0xf0, 0x18, 0xd8, 0x70, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xc0, 0xf0, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xd8, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xd8, 0x70, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xd8, 0xd8, 0x78, 0x18, 0xf0, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0x60, 0x60, 0x60, 0x30, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xd8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0xc0, 0xcf, 0xcc, 0xcc, 0x7f, 0x0c, 0x0c, 0x0f, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x04, 0x7c, 0xce, 0xc8, 0xc8, 0xd0, 0xd0, 0xd0, 0xe0, 0xe6, 0x7c, 0x40, 0x40, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xd6, 0xd8, 0xd8, 0xd8, 0xde, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0xc0, 0xc0, 0xc0, 0xf0, 0xcd, 0xce, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x60, 0xf8, 0x60, 0xf8, 0x60, 0x60, 0xe6, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x02, 0xec, 0xd6, 0xde, 0xd6, 0xd6, 0xf6, 0xd6, 0x40, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x76, 0xff, 0x76, 0x6e, 0xff, 0x6e, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x7c, 0x62, 0x66, 0x6f, 0x66, 0x66, 0xf3, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xf8, 0xe0, 0xf3, 0xd6, 0xdb, 0xce, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x81, 0x81, 0x81, 0x5a, 0xff, 0x5a, 0xff, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xf2, 0x8a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa2, 0xbc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x3e, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x7c, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x36, 0x60, 0xfc, 0x60, 0xf8, 0x60, 0x60, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x6c, 0x78, 0xfe, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x7e, 0x5a, 0x18, 0x1e, 0x78, 0x1e, 0x78, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x7c, 0xb6, 0x36, 0x33, 0x33, 0x33, 0x63, 0x66, 0xf6, 0xdc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xd0, 0xd2, 0xd6, 0x7c, 0x18, 0x30, 0x6e, 0xd8, 0x98, 0x18, 0x0e, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xd0, 0xd2, 0xd6, 0x7c, 0x18, 0x30, 0x6e, 0xd8, 0x8c, 0x06, 0x1c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x62, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0x62, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x4e, 0xb9, 0x58, 0x18, 0x18, 0x18, 0x18, 0x18, 0x19, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x7c, 0xda, 0xd8, 0xd8, 0xda, 0x7c, 0x19, 0x3f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xc0, 0xc2, 0xc6, 0x7c, 0x18, 0x30, 0x6e, 0xdb, 0x9b, 0x1b, 0x0e, 0x00, 0x00, 0x00},
	{0x00, 0x70, 0xc0, 0xc2, 0xc6, 0x7c, 0x18, 0x30, 0x7b, 0xdb, 0x9b, 0x1b, 0x0d, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc2, 0xc0, 0x78, 0xc0, 0xc0, 0xc2, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0x86, 0x26, 0x3e, 0x26, 0x06, 0x86, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7f, 0xb9, 0x58, 0x1a, 0x1e, 0x1a, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x66, 0x46, 0x87, 0x8c, 0x8c, 0x7c, 0x98, 0x98, 0x70, 0x00},
	{0x00, 0x00, 0x52, 0xb5, 0x15, 0x16, 0x2c, 0x34, 0x68, 0xa9, 0xaa, 0x4c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x48, 0xb0, 0x80, 0x48, 0x7c, 0x66, 0x26, 0x26, 0xa6, 0x46, 0x06, 0x34, 0x48, 0x00},
	{0x00, 0x00, 0xe2, 0xa2, 0xa2, 0xa2, 0xbe, 0xa2, 0xa2, 0xa2, 0xa2, 0xe2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x36, 0x3b, 0x3b, 0x33, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x1e, 0x18, 0x76, 0x3b, 0x3b, 0x33, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x33, 0x4e, 0x06, 0x06, 0x0c, 0x0c, 0x1f, 0x6c, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x71, 0x8e, 0x04, 0x0c, 0x06, 0x03, 0x63, 0xc3, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x46, 0x49, 0x39, 0x1e, 0x18, 0x30, 0x70, 0xb1, 0xba, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0e, 0x19, 0x31, 0x32, 0x64, 0x68, 0x70, 0xe1, 0x66, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xd8, 0xff, 0xd8, 0xde, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xde, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe2, 0xa2, 0xb2, 0xb2, 0xaa, 0xaa, 0xa6, 0xa6, 0xa2, 0xe2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xcc, 0xcf, 0xed, 0xff, 0xfc, 0xdf, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0xb9, 0xa5, 0xa5, 0xb9, 0xa1, 0xa1, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x40, 0x8e, 0x93, 0xa3, 0x63, 0x4b, 0x6a, 0xa4, 0xb0, 0xb0, 0x60, 0x00},
	{0x00, 0x00, 0xfc, 0xa2, 0xa2, 0xa2, 0xa2, 0xbc, 0xa0, 0xa0, 0xa0, 0xe0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xaa, 0xa6, 0x7e, 0x01, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3e, 0x4d, 0x4d, 0x19, 0x1e, 0x1c, 0x34, 0x34, 0xb5, 0x62, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x58, 0xa6, 0xa3, 0x6c, 0xb8, 0x26, 0x26, 0x26, 0xa7, 0xc2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0xa2, 0xa2, 0xa2, 0xa2, 0xbc, 0xb0, 0xa8, 0xa4, 0xe2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x6d, 0x67, 0x66, 0xee, 0x08, 0x00, 0x00, 0x00},
	{0x30, 0x0c, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc, 0xd8, 0xdc, 0xdc, 0xe6, 0xe6, 0x20, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x71, 0xdb, 0x35, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x52, 0x5a, 0x52, 0x5f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf1, 0x5b, 0x55, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x18, 0xce, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xe6, 0x6c, 0x38, 0x50, 0x40, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x0a, 0x14, 0x14, 0x28, 0x28, 0x50, 0x50, 0xa0, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x9c, 0x30, 0xfe, 0x0c, 0x18, 0x38, 0x0c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00},
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xee, 0x6c, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x26, 0x03, 0x13, 0x0c, 0x13, 0x03, 0x03, 0x66, 0x98, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x6c, 0x38, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x2d, 0x2d, 0x1a, 0x1e, 0x1b, 0x31, 0x31, 0xb2, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x14, 0x6b, 0xc8, 0xcc, 0xc6, 0xc6, 0xcc, 0xc0, 0x63, 0x1c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0xe7, 0xff, 0xe0, 0x67, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x26, 0x44, 0xf8, 0xc0, 0xc8, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x4c, 0x52, 0x3c, 0x10, 0x3c, 0x60, 0xc0, 0xc3, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x73, 0xce, 0x18, 0x3a, 0x5c, 0x18, 0x30, 0x30, 0xb0, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x2c, 0x3c, 0x2c, 0x8c, 0xcc, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x12, 0x12, 0x12, 0x16, 0x36, 0x3e, 0x3a, 0x5a, 0x52, 0x91, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x26, 0x46, 0xc6, 0xc4, 0xc8, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x42, 0xc6, 0xe7, 0x7a, 0x38, 0x5c, 0xce, 0xe7, 0x63, 0xe2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x80, 0xfc, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x7e, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x40, 0x78, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 0x7e, 0xf2, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x80, 0xfe, 0x7e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x38, 0x00, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7d, 0xff, 0x83, 0x86, 0x82, 0xfe, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xdc, 0x86, 0x1c, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0xe0, 0x30, 0x62, 0xc6, 0xfc, 0x18, 0x30, 0x60, 0xdc, 0x86, 0x1c, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xde, 0x98, 0x1c, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0xe0, 0x30, 0x62, 0xc6, 0xfc, 0x18, 0x30, 0x60, 0xde, 0x98, 0x1c, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0xe0, 0x30, 0x62, 0x36, 0xec, 0x18, 0x30, 0x60, 0xde, 0x98, 0x1c, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0x30, 0x70, 0xb2, 0xf6, 0x3c, 0x18, 0x30, 0x60, 0xde, 0x98, 0x1c, 0x06, 0x1c, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xdc, 0xb0, 0x3c, 0x36, 0x1c, 0x00, 0x00},
	{0x00, 0xf0, 0xc0, 0xe2, 0x36, 0xec, 0x18, 0x30, 0x60, 0xdc, 0xb0, 0x3c, 0x36, 0x1c, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xdc, 0xb6, 0x1c, 0x36, 0x1c, 0x00, 0x00},
	{0x00, 0xe0, 0x30, 0x62, 0x36, 0xec, 0x18, 0x30, 0x60, 0xdc, 0xb6, 0x1c, 0x36, 0x1c, 0x00, 0x00},
	{0x00, 0xf0, 0x80, 0xe2, 0x36, 0xec, 0x18, 0x30, 0x60, 0xdc, 0xb6, 0x1c, 0x36, 0x1c, 0x00, 0x00},
	{0x00, 0xf0, 0x30, 0x62, 0x66, 0x6c, 0x18, 0x30, 0x60, 0xdc, 0xb6, 0x1c, 0x36, 0x1c, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xce, 0xce, 0xc4, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x73, 0x73, 0x23, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x95, 0x95, 0x95, 0x95, 0x95, 0x95, 0x95, 0x65, 0x65, 0x65, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0xdb, 0xce, 0xce, 0xce, 0xdb, 0xdb, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x38, 0x7c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0xdb, 0x73, 0x73, 0x73, 0xdb, 0xdb, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x95, 0x95, 0x95, 0x65, 0x65, 0x65, 0x95, 0x95, 0x95, 0x95, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xdb, 0xdb, 0x00, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0x00, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xce, 0xc4, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x00, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x73, 0x23, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x05, 0x05, 0x00, 0x95, 0x95, 0x95, 0x95, 0x95, 0x65, 0x65, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x15, 0x15, 0x00, 0xb5, 0xb5, 0xb5, 0xb5, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0x00, 0xdb, 0xdb, 0xce, 0xce, 0xce, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x00, 0xdb, 0xdb, 0x73, 0x73, 0x73, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x05, 0x05, 0x00, 0x95, 0x95, 0x65, 0x65, 0x95, 0x95, 0x95, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xfe, 0xd6, 0xd6, 0xd6, 0xd6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x5a, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x5a, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0xcc, 0xe6, 0xd6, 0xd6, 0xd6, 0xd6, 0xe6, 0xcc, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x5a, 0x99, 0xbd, 0xdb, 0xdb, 0xbd, 0x99, 0x5a, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0xcc, 0x86, 0x06, 0x06, 0x06, 0x06, 0x86, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xff, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0xff, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xf0, 0xe0, 0xb0, 0x18, 0x0c, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x0f, 0x07, 0x0d, 0x18, 0x30, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc0, 0x60, 0x30, 0x18, 0x0d, 0x07, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x0c, 0x18, 0xb0, 0xe0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x62, 0xff, 0x64, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x26, 0xff, 0x46, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xce, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x73, 0xdd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0xff, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x36, 0xff, 0x36, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x66, 0xfc, 0x66, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x66, 0x3f, 0x66, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x63, 0xff, 0x63, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xc6, 0xff, 0xc6, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x33, 0x63, 0xfe, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x60, 0xcc, 0xc6, 0x7f, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x3b, 0x6b, 0xfe, 0x68, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x60, 0xdc, 0xd6, 0x7f, 0x16, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x5a, 0xff, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x6e, 0xff, 0x76, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x30, 0x60, 0x63, 0xff, 0xc6, 0x16, 0x1c, 0x1c, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x30, 0x60, 0xfe, 0x66, 0x36, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x0c, 0xfe, 0xcc, 0xd8, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x36, 0x66, 0xfe, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xd8, 0xcc, 0xfe, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x0c, 0x0c, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x36, 0x66, 0xfe, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x1e, 0x33, 0x33, 0x33, 0x30, 0xfc, 0x78, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0x0c, 0x3f, 0x1e, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0x00, 0xf0, 0xe0, 0xb0, 0x18, 0x0c, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x98, 0xb0, 0xff, 0xb0, 0x98, 0x19, 0x0d, 0xff, 0x0d, 0x19, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x1e, 0x1c, 0x16, 0x03, 0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x78, 0x38, 0x68, 0xc0, 0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x1c, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1e, 0x1c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x06, 0xff, 0x06, 0x0c, 0x30, 0x60, 0xff, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x2e, 0x3f, 0x24, 0x24, 0x24, 0x24, 0xfc, 0x74, 0x24, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x60, 0xff, 0x60, 0x30, 0x0c, 0x06, 0xff, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x7e, 0xff, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0xff, 0x7e, 0x24, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xff, 0x00, 0xff, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0xff, 0x00, 0xff, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x7f, 0xc4, 0x7f, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x7e, 0xcb, 0x7e, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xfe, 0x23, 0xfe, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7f, 0xc0, 0x7f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x7c, 0xee, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xfe, 0x03, 0xfe, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xee, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x7e, 0xc3, 0x7e, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x7c, 0xee, 0x6c, 0x6c, 0x6c, 0x6c, 0xee, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xf0, 0xe0, 0xb0, 0xd8, 0xec, 0xb6, 0x1b, 0x0c, 0x04, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x0f, 0x07, 0x0d, 0x1b, 0x37, 0x6d, 0xd8, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x20, 0x30, 0xd8, 0x6d, 0x37, 0x1b, 0x0d, 0x07, 0x0f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x0c, 0x1b, 0xb6, 0xec, 0xd8, 0xb0, 0xe0, 0xf0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x3f, 0x60, 0xff, 0x60, 0x3f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x06, 0xff, 0x06, 0xfc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x6a, 0xff, 0x65, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xa6, 0xff, 0x56, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x3c, 0x18, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x3c, 0x18, 0x3c, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xd5, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x66, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x06, 0xab, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xb0, 0xff, 0xb0, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x0d, 0xff, 0x0d, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x3f, 0x41, 0x81, 0x41, 0x3f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x44, 0xc6, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x82, 0x81, 0x82, 0xfc, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x44, 0xc6, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x44, 0xc6, 0x44, 0x44, 0x7c, 0x00, 0x7c, 0x44, 0x7c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x44, 0xc6, 0x44, 0x44, 0x44, 0xc6, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x7c, 0xc6, 0x44, 0x44, 0x44, 0xc6, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x54, 0xd6, 0x54, 0x54, 0x54, 0xd6, 0x92, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x28, 0x54, 0xee, 0x44, 0xc6, 0x44, 0x44, 0x44, 0x44, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x28, 0x54, 0xee, 0x44, 0xc6, 0x44, 0x44, 0xc6, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xe8, 0xbc, 0x82, 0x81, 0x82, 0xbc, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0x80, 0xbc, 0xb8, 0xac, 0x86, 0x83, 0x81, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x01, 0x81, 0xc1, 0x61, 0x35, 0x1d, 0x3d, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x44, 0xc6, 0x44, 0x44, 0x44, 0xc6, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0xfe, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x3c, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x06, 0x06, 0x3e, 0x66, 0xc6, 0xc6, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x7e, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0xfe, 0x16, 0x16, 0x16, 0x7e, 0x16, 0x26, 0x26, 0x26, 0xfe, 0x40, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x03, 0x3e, 0x66, 0xcf, 0xdb, 0xdb, 0xf3, 0x66, 0x7c, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x3e, 0x60, 0xc0, 0xc0, 0xfe, 0xc0, 0xc0, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x3e, 0x64, 0xc8, 0xc8, 0xfe, 0xc8, 0xd0, 0x70, 0x3e, 0x20, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0xc0, 0xfe, 0xc0, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xf8, 0x0c, 0x06, 0x06, 0xfe, 0x06, 0x06, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0xf8, 0x1c, 0x16, 0x26, 0xfe, 0x26, 0x26, 0x4c, 0xf8, 0x40, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x06, 0xfe, 0x06, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xe7, 0x00, 0x00},
	{0x00, 0x00, 0xe7, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0xc1, 0x60, 0x30, 0x18, 0x0c, 0x0c, 0x18, 0x30, 0x60, 0xc1, 0xff, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0xc0, 0xc0, 0x00, 0x00, 0x00},
	{0x00, 0xc0, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x7e, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x06, 0x06, 0x06, 0x0c, 0xcc, 0x6c, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe3, 0x33, 0x66, 0x36, 0xe6, 0x0c, 0xcc, 0x6c, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x33, 0x73, 0xb6, 0xf6, 0x36, 0x0c, 0xcc, 0x6c, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdb, 0xdb, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x16, 0x0c, 0x1c, 0x34, 0x62, 0xff, 0x02, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x38, 0xe8, 0x38, 0x0e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x1a, 0x1c, 0x38, 0x58, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6e, 0x7c, 0xec, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x1a, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x58, 0x30, 0x00, 0x00},
	{0x33, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xcc, 0x00, 0x00},
	{0x2a, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0xa8, 0x00, 0x00},
	{0x0c, 0x1a, 0x18, 0x18, 0x3c, 0x5a, 0x99, 0x99, 0x5a, 0x3c, 0x18, 0x18, 0x58, 0x30, 0x00, 0x00},
	{0x33, 0x66, 0x66, 0x66, 0x7e, 0xe7, 0xe7, 0xe7, 0xe7, 0x7e, 0x66, 0x66, 0x66, 0xcc, 0x00, 0x00},
	{0x2a, 0x54, 0x54, 0x54, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x54, 0x54, 0x54, 0xa8, 0x00, 0x00},
	{0x18, 0x34, 0x30, 0x30, 0x38, 0x35, 0x33, 0x37, 0x30, 0x30, 0x30, 0x30, 0xb0, 0x60, 0x00, 0x00},
	{0x0c, 0x1a, 0x18, 0x18, 0x3c, 0x5a, 0xfa, 0x5a, 0x5a, 0x3c, 0x18, 0x18, 0x58, 0x30, 0x00, 0x00},
	{0x0c, 0x1a, 0x18, 0x18, 0x3c, 0x5a, 0x5f, 0x5a, 0x5a, 0x3c, 0x18, 0x18, 0x58, 0x30, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0xfc, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x7e, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x76, 0xdc, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xdb, 0xdb, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0xd8, 0xdb, 0xdb, 0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x1c, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x76, 0xdc, 0x10, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x08, 0x76, 0xdc, 0x10, 0xfe, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x08, 0xfe, 0x10, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x08, 0x76, 0xdc, 0x10, 0xfe, 0x20, 0xfe, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x08, 0x76, 0xdc, 0x10, 0x76, 0xdc, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x7c, 0x00, 0x7c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x66, 0x00, 0x00, 0x66, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x66, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0x60, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x06, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc0, 0xdf, 0x00, 0x00, 0xdf, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x03, 0xfb, 0x00, 0x00, 0xfb, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x28, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x38, 0x44, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x44, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x44, 0x28, 0x10, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x10, 0x7c, 0x28, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x10, 0x28, 0x44, 0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x26, 0x7c, 0xb4, 0x6c, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x68, 0x54, 0x54, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x08, 0x10, 0x00, 0x10, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x08, 0x7e, 0x08, 0x10, 0x7e, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x08, 0xfe, 0x08, 0x10, 0xfe, 0x10, 0x20, 0xfe, 0x20, 0x40, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x08, 0xfe, 0x10, 0xfe, 0x20, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x08, 0xfe, 0x10, 0xfe, 0x20, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x1b, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x1b, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0xce, 0x7c, 0x10, 0x7c, 0xe6, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x04, 0x0e, 0x38, 0xe8, 0x38, 0x0e, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0xe0, 0x38, 0x2e, 0x38, 0xe0, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x04, 0x0e, 0x38, 0xe8, 0x38, 0x0e, 0x10, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0xe0, 0x38, 0x2e, 0x38, 0xe0, 0x40, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x04, 0x0e, 0x38, 0xe8, 0x38, 0x0e, 0x10, 0x76, 0xdc, 0x20, 0x20, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0xe0, 0x38, 0x2e, 0x38, 0xe0, 0x40, 0x76, 0xdc, 0x80, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x0e, 0x38, 0xe8, 0x38, 0x1e, 0xf0, 0x38, 0x2e, 0x38, 0xe0, 0x20, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0xe8, 0x38, 0x0e, 0x38, 0xf0, 0x1e, 0x38, 0xe0, 0x38, 0x2e, 0x20, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x02, 0x06, 0x1c, 0xf0, 0x1c, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x80, 0xc0, 0x70, 0x1e, 0x70, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x02, 0x06, 0x1c, 0xf0, 0x1c, 0x06, 0xf2, 0x1c, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x80, 0xc0, 0x70, 0x1e, 0x70, 0xc0, 0x9e, 0x70, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x02, 0x06, 0x1c, 0xf0, 0x1c, 0x06, 0x02, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x80, 0xc0, 0x70, 0x1e, 0x70, 0xc0, 0x80, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x06, 0x0c, 0x38, 0xe8, 0x38, 0x1c, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0xd0, 0x70, 0x38, 0x2e, 0x38, 0x60, 0xc0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x7e, 0xc8, 0xc8, 0xd0, 0xd0, 0x7e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0xfc, 0x16, 0x16, 0x26, 0x26, 0xfc, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x7e, 0xc8, 0xc8, 0xd0, 0xd0, 0x7e, 0x20, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0xfc, 0x16, 0x16, 0x26, 0x26, 0xfc, 0x40, 0xfe, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0xc0, 0x7e, 0x08, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x10, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x82, 0x92, 0xa2, 0xfa, 0xa2, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92, 0xba, 0xba, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92, 0xba, 0x92, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x54, 0x92, 0xfe, 0x92, 0x54, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0xfe, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0xaa, 0x92, 0xaa, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x8a, 0x92, 0xa2, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xba, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xaa, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x54, 0xd6, 0xba, 0xd6, 0x54, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0xba, 0x82, 0xba, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0xba, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x92, 0x92, 0xfe, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0xfe, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xaa, 0x92, 0xaa, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x92, 0xba, 0x92, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0xff, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x7e, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x7e, 0x60, 0x7e, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xff, 0xc0, 0xff, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xd8, 0xd8, 0xd8, 0xd8, 0xdf, 0xd8, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xa8, 0xa8, 0xa8, 0xa8, 0xaf, 0xa8, 0xa8, 0xa8, 0xa8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xd8, 0xd8, 0xd8, 0xdf, 0xd8, 0xdf, 0xd8, 0xd8, 0xd8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xc2, 0xc4, 0xc4, 0xff, 0xc8, 0xc8, 0xd0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xc4, 0xc4, 0xff, 0xc8, 0xff, 0xd0, 0xd0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xd8, 0xd9, 0xda, 0xda, 0xdf, 0xda, 0xda, 0xdc, 0xd8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xd8, 0xd9, 0xda, 0xdf, 0xda, 0xdf, 0xda, 0xdc, 0xd8, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x0c, 0x06, 0x1c, 0xf0, 0x1c, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x60, 0xc0, 0x70, 0x1e, 0x70, 0xc0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x06, 0x1e, 0x76, 0xc6, 0x76, 0x1e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc0, 0xf0, 0xdc, 0xc6, 0xdc, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x1e, 0x76, 0xc6, 0x76, 0x1e, 0x06, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xf0, 0xdc, 0xc6, 0xdc, 0xf0, 0xc0, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xbf, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xfd, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x7d, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0xc6, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xf0, 0xc8, 0xc4, 0xc4, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x0b, 0x13, 0x23, 0x43, 0x83, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x38, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x92, 0x44, 0x28, 0x92, 0x28, 0x44, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x82, 0xc4, 0xa8, 0x90, 0xa8, 0xc4, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x82, 0x46, 0x2a, 0x12, 0x2a, 0x46, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x3e, 0x60, 0xce, 0xd8, 0xd8, 0xce, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xf8, 0x0c, 0xe6, 0x36, 0x36, 0xe6, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x38, 0x44, 0x92, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x92, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x10, 0x38, 0x54, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x64, 0xce, 0x64, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x4c, 0xe6, 0x4c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x15, 0x2a, 0x54, 0xa8, 0x54, 0x2a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xa8, 0x54, 0x2a, 0x15, 0x2a, 0x54, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0xfe, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0x00},
	{0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0xfe, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x02, 0x06, 0x1c, 0xf2, 0x06, 0x1c, 0xf0, 0x1c, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x80, 0xc0, 0x70, 0x9e, 0xc0, 0x70, 0x1e, 0x70, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0a, 0x0e, 0x1c, 0xf0, 0x1c, 0x16, 0xf2, 0x1c, 0x26, 0x22, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x88, 0xc8, 0x70, 0x1e, 0x70, 0xd0, 0x9e, 0x70, 0xe0, 0xa0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0xfe, 0xc8, 0xc8, 0xd0, 0xd0, 0xfe, 0x20, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0xfe, 0x16, 0x16, 0x26, 0x26, 0xfe, 0x40, 0xfe, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x08, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x10, 0xfe, 0x20, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x38, 0x0e, 0x10, 0x76, 0xdc, 0x10, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xe0, 0x38, 0x0e, 0x38, 0xe0, 0x10, 0x76, 0xdc, 0x10, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x02, 0x06, 0x1c, 0xf0, 0x1c, 0x06, 0x02, 0x10, 0x76, 0xdc, 0x10, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x80, 0xc0, 0x70, 0x1e, 0x70, 0xc0, 0x80, 0x10, 0x76, 0xdc, 0x10, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x0e, 0x1e, 0x76, 0xd6, 0x76, 0x1e, 0x26, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0xc8, 0xf0, 0xdc, 0xd6, 0xdc, 0xf0, 0xe0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x0e, 0x1e, 0x76, 0xd6, 0x76, 0x1e, 0x26, 0x20, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0xc8, 0xf0, 0xdc, 0xd6, 0xdc, 0xf0, 0xe0, 0x20, 0xfe, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x3d, 0x66, 0xc7, 0xcb, 0xd3, 0xe3, 0x66, 0xbc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x42, 0xa5, 0x7e, 0x24, 0x24, 0x7e, 0xa5, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x38, 0x38, 0x54, 0x8a, 0xf6, 0x82, 0x54, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0xfe, 0xfe, 0x44, 0x44, 0x28, 0x10, 0x28, 0x44, 0x44, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x00, 0x00},
	{0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60, 0x00, 0x00},
	{0x00, 0x03, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30},
	{0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30},
	{0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x03, 0x00, 0x00},
	{0x00, 0xc0, 0x60, 0x30, 0x30, 0x18, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c},
	{0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c},
	{0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x18, 0x18, 0x30, 0x30, 0x60, 0xc0, 0x00, 0x00},
	{0x00, 0x3f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30},
	{0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30},
	{0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3f, 0x00, 0x00},
	{0x00, 0xfc, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c},
	{0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c},
	{0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xfc, 0x00, 0x00},
	{0x00, 0x07, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0xe0, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x07, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0xe0, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x07, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0xe0, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x07, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0xe0},
	{0xe0, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x07},
	{0x00, 0x00, 0xff, 0xc1, 0xc0, 0x60, 0x60, 0x60, 0x60, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0x60, 0xc0, 0xc1, 0xff, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xff, 0x00, 0xff, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0x78, 0x78, 0x38, 0x38, 0x18, 0x18, 0x00, 0x00},
	{0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0},
	{0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03},
	{0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x07, 0x05, 0x05, 0x05, 0x05, 0x25, 0x79, 0xc2, 0x7c, 0x20, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xd8, 0xd8, 0xf8, 0xd8, 0xd8, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xf0, 0x0f, 0x0c, 0x0e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xd8, 0xd8, 0xf8, 0x70, 0x20, 0x0f, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xf0, 0xc0, 0xe0, 0xc0, 0xc0, 0x0f, 0x0c, 0x0e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0xc0, 0xc0, 0xc0, 0x70, 0x1e, 0x1b, 0x1e, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x98, 0xd8, 0xf8, 0xd8, 0xd8, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7c, 0xfe, 0xc6, 0xc6, 0x60, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00},
	{0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1f, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xfc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0x1f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0xff, 0xff, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0e, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x70, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x70, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x0e, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80},
	{0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01},
	{0x81, 0x81, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x81, 0x81},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe},
	{0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc},
	{0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8},
	{0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0},
	{0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0},
	{0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0},
	{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
	{0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},
	{0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44},
	{0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa},
	{0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77},
	{0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01},
	{0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x7c, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x82, 0xba, 0xba, 0xba, 0xba, 0xba, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x82, 0xfe, 0x82, 0xfe, 0x82, 0xfe, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0xaa, 0xfe, 0xaa, 0xfe, 0xaa, 0xfe, 0xaa, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x8a, 0xc6, 0xa2, 0x92, 0x8a, 0xc6, 0xa2, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0xa2, 0xc6, 0x8a, 0x92, 0xa2, 0xc6, 0x8a, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0xaa, 0xc6, 0xaa, 0x92, 0xaa, 0xc6, 0xaa, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x44, 0x44, 0x44, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0xfc, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42, 0x84, 0x84, 0xfc, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x7c, 0x7c, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x80, 0xc0, 0xa0, 0x90, 0x88, 0x84, 0x88, 0x90, 0xa0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x70, 0x78, 0x70, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x70, 0x48, 0x70, 0x40, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x80, 0xe0, 0xf8, 0xfe, 0xf8, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x80, 0xe0, 0x98, 0x86, 0x98, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xfe, 0x7c, 0x7c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x02, 0x06, 0x0e, 0x1e, 0x3e, 0x7e, 0x3e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x02, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x38, 0x78, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x38, 0x48, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x02, 0x0e, 0x3e, 0xfe, 0x3e, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x02, 0x0e, 0x32, 0xc2, 0x32, 0x0e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x38, 0x7c, 0x7c, 0xfe, 0xfe, 0x7c, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x44, 0x44, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x44, 0x54, 0xba, 0xba, 0x54, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x99, 0xbd, 0xbd, 0xbd, 0xbd, 0x99, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x28, 0x28, 0x44, 0x82, 0x82, 0x44, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x14, 0x40, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x02, 0x28, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0xa5, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x99, 0xa5, 0xa5, 0xa5, 0xa5, 0x99, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x72, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0x72, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x4e, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x4e, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x81, 0xff, 0xff, 0xff, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x7e, 0xff, 0xff, 0xff, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x4e, 0x8f, 0x8f, 0x8f, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x4e, 0x8f, 0x8f, 0x8f, 0xff, 0xff, 0xff, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x70, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x0e, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0e, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0xff, 0xff, 0xc3, 0xbd, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff},
	{0xff, 0xff, 0xc3, 0xbd, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0x30, 0x40, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0c, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x40, 0x30, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x01, 0x01, 0x03, 0x03, 0x07, 0x07, 0x0f, 0x0f, 0x1f, 0x1f, 0x3f, 0x3f, 0x7f, 0x7f, 0xff, 0xff},
	{0x80, 0x80, 0xc0, 0xc0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf8, 0xf8, 0xfc, 0xfc, 0xfe, 0xfe, 0xff, 0xff},
	{0xff, 0xff, 0xfe, 0xfe, 0xfc, 0xfc, 0xf8, 0xf8, 0xf0, 0xf0, 0xe0, 0xe0, 0xc0, 0xc0, 0x80, 0x80},
	{0xff, 0xff, 0x7f, 0x7f, 0x3f, 0x3f, 0x1f, 0x1f, 0x0f, 0x0f, 0x07, 0x07, 0x03, 0x03, 0x01, 0x01},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0xff, 0xfd, 0xf9, 0xf1, 0xf1, 0xe1, 0xc1, 0x81, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0x81, 0x83, 0x87, 0x8f, 0x8f, 0x9f, 0xbf, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xff, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x92, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x74, 0x74, 0xf2, 0xf2, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x5c, 0x5c, 0x9e, 0x9e, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x92, 0x92, 0x92, 0xf2, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0xf2, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x9e, 0x92, 0x92, 0x92, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xfe, 0x92, 0x92, 0x92, 0x9e, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x4a, 0x89, 0x89, 0x89, 0xf9, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0xf9, 0x89, 0x89, 0x89, 0x4a, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x81, 0x81, 0x9f, 0x91, 0x91, 0x91, 0x52, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x52, 0x91, 0x91, 0x91, 0x9f, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x54, 0x38, 0xfe, 0x38, 0x54, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x30, 0x7c, 0xfe, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x38, 0x7c, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0xfe, 0x7c, 0x38, 0x6c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0xee, 0x44, 0x54, 0x6c, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x18, 0x30, 0x60, 0xc0, 0x60, 0x34, 0x1c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcd, 0xc7, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x92, 0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0xa5, 0xa5, 0x42, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x42, 0xa5, 0xa5, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x78, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x36, 0x36, 0x1c, 0x18, 0x30, 0x70, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x86, 0x8a, 0xba, 0x92, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0xee, 0xba, 0xba, 0xee, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x82, 0xc6, 0x6c, 0x7c, 0x38, 0x7c, 0x6c, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0x82, 0xaa, 0x82, 0x44, 0x7c, 0x44, 0x38, 0x00, 0x44, 0xc6, 0x38, 0xc6, 0x44, 0x00},
	{0x00, 0x00, 0x00, 0x38, 0x44, 0xee, 0xfe, 0x92, 0xba, 0x7c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x7e, 0x18, 0x18, 0xff, 0x18, 0x1e, 0x78, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x7e, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x38, 0x10, 0x10, 0x92, 0xfe, 0x92, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x72, 0xe0, 0xc4, 0xdf, 0xce, 0xca, 0xe0, 0x72, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x54, 0x28, 0x54, 0xaa, 0xaa, 0xaa, 0xaa, 0x54, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x5a, 0x99, 0x99, 0x99, 0xbd, 0xff, 0xdb, 0x5a, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x42, 0x81, 0x85, 0xb1, 0xf9, 0xff, 0xdf, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xfe, 0xfe, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0xee, 0xee, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0x81, 0x99, 0xa5, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xa5, 0x99, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xdb, 0xe7, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x54, 0x28, 0xc6, 0x28, 0x54, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x78, 0x14, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x14, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x28, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x28, 0x1e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x66, 0x66, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x06, 0x0e, 0x1a, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x03, 0x03, 0x7b, 0xcf, 0xcf, 0xcf, 0x0f, 0x1b, 0x33, 0xff, 0x03, 0x03, 0x03, 0x00, 0x00},
	{0x00, 0x00, 0x60, 0xf0, 0x60, 0x6e, 0x73, 0x63, 0x63, 0x66, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xd6, 0x54, 0x54, 0x7c, 0x54, 0x54, 0xd6, 0x38, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0xdb, 0xdb, 0xdb, 0xdb, 0x7e, 0x3c, 0x18, 0x3c, 0x18, 0x18, 0x00, 0x00},
	{0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xcc, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x42, 0xa5, 0xa5, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0xc3, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00},
	{0x00, 0x00, 0xc3, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0xc3, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0xdb, 0xd8, 0x70, 0x00, 0x00, 0x0e, 0x1b, 0xdb, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1e, 0x33, 0x33, 0x33, 0x33, 0x1b, 0x7b, 0xdb, 0xdb, 0x73, 0x03, 0x01, 0x00, 0x00},
	{0x00, 0x00, 0x94, 0x7c, 0x55, 0x57, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x06, 0x0b, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x24, 0xe7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x94, 0x7c, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x04, 0x03, 0x00, 0x00},
	{0x00, 0x00, 0x1f, 0x07, 0x8f, 0xdb, 0x73, 0x70, 0xd8, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x90, 0x50, 0x70, 0x68, 0x48, 0x48, 0x4e, 0x49, 0x09, 0x0e, 0x10, 0x20, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x2a, 0x7e, 0xaa, 0x00, 0x00, 0x2a, 0x7e, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc3, 0x66, 0x66, 0x66, 0x66, 0xff, 0x66, 0x66, 0x66, 0x66, 0xc3, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x6c, 0x92, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0xe7, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x81, 0x81, 0x66, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x24, 0x3c, 0xe7, 0xa5, 0xe7, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x78, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x30, 0x3c, 0x3e, 0x32, 0x30, 0x30, 0x30, 0x70, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0x7f, 0x6f, 0x63, 0x63, 0x63, 0x63, 0xe3, 0xe7, 0xc7, 0x06, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7f, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x63, 0xe7, 0xe7, 0xc6, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xde, 0xe6, 0xc4, 0xd8, 0xe0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x40, 0x40, 0x44, 0x5c, 0x74, 0x44, 0x44, 0x5c, 0x74, 0x44, 0x04, 0x04, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x04, 0x46, 0x5c, 0x74, 0xc4, 0x46, 0x5c, 0x74, 0xc4, 0x40, 0x40, 0x00, 0x00},
	{0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0xff, 0x66, 0x66, 0x66, 0x66, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x6e, 0x66, 0x60, 0xfe, 0x66, 0x66, 0x66, 0x66, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3e, 0x6e, 0x66, 0x66, 0xfe, 0x66, 0x66, 0x66, 0x66, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6e, 0xdb, 0xdb, 0xd8, 0xff, 0xdb, 0xdb, 0xdb, 0xdb, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x6f, 0xdb, 0xdb, 0xdb, 0xff, 0xdb, 0xdb, 0xdb, 0xdb, 0xff, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x38, 0x6c, 0x6c, 0x6f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6d, 0xf6, 0x00, 0x00, 0x00, 0x00},
	{0x06, 0x29, 0x5e, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x06, 0x29, 0x5e, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x08, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x08, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x14, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x14, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x14, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x00, 0x0a, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x00, 0x0a, 0x00, 0x06, 0x49, 0x89, 0x86, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x0c, 0x12, 0x0a, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0a, 0x00, 0x0a, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0a, 0x00, 0x0a, 0x00, 0x06, 0x49, 0x89, 0x86, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x14, 0x00, 0x14, 0x00, 0x0c, 0x12, 0x0a, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x14, 0x00, 0x14, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x88, 0x80, 0x88, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0x41, 0x88, 0x80, 0x88, 0x40, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x47, 0x18, 0xe0, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0xc1, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x94, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0x41, 0x80, 0x94, 0x80, 0x40, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x47, 0x18, 0xe0, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0xc1, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x94, 0x80, 0x88, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0x41, 0x94, 0x80, 0x88, 0x40, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x47, 0x18, 0xe0, 0x00, 0x0a, 0x00, 0x04, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0xc1, 0x00, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x94, 0x80, 0x94, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0x41, 0x94, 0x80, 0x94, 0x40, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x47, 0x18, 0xe0, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0xc1, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0x46, 0x39, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x28, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x28, 0x00, 0x08, 0x08, 0x04, 0x46, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x00, 0x28, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x00, 0x28, 0x00, 0x08, 0x08, 0x04, 0x46, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x20, 0x38, 0x28, 0x70, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x20, 0x38, 0x28, 0x70, 0x08, 0x08, 0x04, 0x46, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x00, 0x14, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x00, 0x04, 0x07, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x00, 0x00, 0x04, 0x07, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x01, 0x02, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x01, 0x02, 0x04, 0x08, 0x48, 0x84, 0x82, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x18, 0x20, 0x10, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x18, 0x20, 0x20, 0x10, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x04, 0x08, 0x48, 0x84, 0x82, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x30, 0x46, 0x18, 0x20, 0x10, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x30, 0x46, 0x18, 0x20, 0x20, 0x10, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00},
	{0x04, 0x09, 0x12, 0x04, 0x08, 0x48, 0x84, 0x82, 0x7d, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00},
	{0x0c, 0x30, 0x46, 0x18, 0x20, 0x10, 0x08, 0x08, 0xf0, 0x00, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00},
	{0x0c, 0x30, 0x46, 0x18, 0x20, 0x20, 0x10, 0x08, 0xf7, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0xa4, 0x09, 0x12, 0x04, 0x08, 0x44, 0x82, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xa4, 0x09, 0x12, 0x04, 0x08, 0x48, 0x84, 0x82, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xa2, 0x0c, 0x13, 0x0c, 0x10, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xa2, 0x0c, 0x13, 0x0c, 0x10, 0x10, 0x08, 0x04, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x41, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x00, 0x00, 0x01, 0x41, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x1c, 0x14, 0x38, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x38, 0x40, 0x38, 0x40, 0x18, 0x24, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x70, 0x80, 0x70, 0x80, 0x10, 0x68, 0x88, 0x74, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf0, 0x10, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf7, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x38, 0x4c, 0x52, 0x32, 0x3d, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x38, 0x4c, 0x52, 0x32, 0x3d, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x38, 0x4c, 0x52, 0x32, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x38, 0x4c, 0x52, 0x32, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x60, 0x80, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x18, 0x20, 0x3f, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x70, 0x80, 0x70, 0x80, 0x08, 0x14, 0x60, 0x80, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1c, 0x20, 0x1c, 0x20, 0x00, 0x00, 0x07, 0x18, 0x20, 0x3f, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x00, 0x29, 0x01, 0x19, 0x21, 0x19, 0xa1, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x00, 0x2a, 0x02, 0x32, 0x42, 0x32, 0xc6, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x40, 0x00, 0xa3, 0x0c, 0x10, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x40, 0x00, 0xa3, 0x0c, 0x10, 0x10, 0x08, 0x04, 0xfb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x28, 0x18, 0x10, 0x20, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x28, 0x18, 0x10, 0x20, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x08, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x08, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x08, 0x08, 0x08, 0x08, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x23, 0x54, 0x33, 0x24, 0x40, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x3c, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x08, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x3c, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x14, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x14, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x10, 0x00, 0x10},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x88, 0x87, 0x81, 0x7e, 0x10, 0x00, 0x10},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x88, 0x87, 0x81, 0x7e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x20, 0x20, 0x20, 0x20, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x10, 0x10, 0x10, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x10, 0x10, 0x10, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x24, 0x98, 0x60, 0xc2, 0x12, 0x92, 0x9c, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x02, 0x92, 0x9c, 0x60, 0x0e, 0x70, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x60, 0x04, 0x54, 0x58, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x28, 0x10, 0x60, 0x04, 0x54, 0x58, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x04, 0x54, 0x58, 0x20, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x10, 0x04, 0x54, 0x58, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x07, 0x88, 0x87, 0x81, 0x7e, 0x00, 0x00, 0x00},
	{0x0e, 0xf0, 0x02, 0x92, 0x9c, 0x60, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x24, 0x18, 0x60, 0x02, 0x92, 0x9c, 0x60, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x02, 0x12, 0x9c, 0x60, 0x0e, 0x70, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x10, 0x28, 0x50, 0x28, 0x08, 0x08, 0x08, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x14, 0x28, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x08, 0x10, 0x54, 0x38, 0x54, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x10, 0x08, 0x2a, 0x1c, 0x2a, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x2a, 0x14, 0x00, 0x21, 0x69, 0xa9, 0x69, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x08, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x20, 0x10, 0x10, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x04, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7c, 0x28, 0x7c, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x28, 0x10, 0x2a, 0x24, 0x1a, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x38, 0x38, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x30, 0x18, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x08, 0x08, 0x10, 0x10, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x54, 0x58, 0x40, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x30, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x06, 0x18, 0x60, 0x06, 0x18, 0x60, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x12, 0xca, 0x2c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x0c, 0x30, 0x00, 0x00},
	{0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x06, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x08, 0x14, 0x0c, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x24, 0x14, 0x18, 0x60, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x06, 0x18, 0x60, 0x00, 0x00},
	{0x0a, 0x2a, 0x2c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x02, 0x12, 0x92, 0x9c, 0x60, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x20, 0x1e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x02, 0x3c, 0x40, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x01, 0x3e, 0x40, 0x08, 0x08, 0x08, 0x08, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x18, 0x20, 0x1c, 0x20, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x0c, 0x10, 0x0e, 0x10, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x1c, 0x20, 0x1c, 0x20, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x1c, 0x20, 0x1c, 0x20, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x0c, 0x10, 0x0e, 0x10, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x00, 0x0c, 0x10, 0x0e, 0x10, 0x00, 0x00},
	{0x00, 0x30, 0x40, 0x38, 0x40, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x30, 0x40, 0x38, 0x40, 0x00, 0x00, 0x00, 0x07, 0x88, 0x87, 0x81, 0x7e, 0x00, 0x00, 0x00},
	{0x00, 0x1c, 0x20, 0x1c, 0x20, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x1c, 0x20, 0x1c, 0x20, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x28, 0x00, 0x00, 0x18, 0x24, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x50, 0x00, 0x10, 0x10, 0x68, 0x88, 0x74, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x14, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x14, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x14, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x40, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x40, 0x80, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x88, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0x41, 0x80, 0x88, 0x80, 0x40, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x47, 0x18, 0xe0, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0xc1, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0x41, 0x80, 0x80, 0x80, 0x40, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x47, 0x18, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x8f, 0x32, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x20, 0x00, 0x00, 0x70, 0x8f, 0x30, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x00, 0x00, 0x70, 0x8f, 0x32, 0x41, 0x80, 0x80, 0x80, 0x40, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x00, 0x38, 0x47, 0x18, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x00, 0x00, 0x70, 0x8f, 0x32, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0x46, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x00, 0x08, 0x04, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x00, 0x08, 0x08, 0x04, 0x46, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x07, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x02, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x07, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x15, 0x88, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x15, 0x88, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x15, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x01, 0x15, 0x88, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x01, 0x15, 0x88, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x04, 0x00, 0x0a, 0x00, 0x00, 0x01, 0x15, 0xea, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x14, 0x00, 0x00, 0x00, 0x2a, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x29, 0x31, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x29, 0x31, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x04, 0x00, 0x06, 0x09, 0x31, 0x9e, 0x88, 0x88, 0x70, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x00, 0x06, 0x29, 0x31, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x00, 0x06, 0x29, 0x31, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x20, 0x20, 0x2c, 0x32, 0xa2, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x20, 0x20, 0x2c, 0x32, 0xa2, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x20, 0x20, 0x2c, 0x32, 0x22, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x20, 0x20, 0x20, 0x2c, 0x32, 0x22, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x20, 0x20, 0x2c, 0x32, 0xa2, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x20, 0x20, 0x2c, 0x32, 0xa2, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x20, 0x20, 0x2c, 0x32, 0x22, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x24, 0x20, 0x20, 0x2c, 0x32, 0x22, 0xfd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x70, 0x80, 0x8c, 0x70, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x1c, 0x22, 0x41, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x1c, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x40, 0x00, 0x00, 0x70, 0x80, 0x8c, 0x70, 0x40, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x08, 0x00, 0x00, 0x1e, 0x22, 0x1c, 0x22, 0x41, 0x80, 0x80, 0x80, 0x41, 0x3e, 0x00, 0x00},
	{0x00, 0x00, 0x10, 0x00, 0x00, 0x0e, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x00, 0x1e, 0x22, 0x1c, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x49, 0x85, 0x83, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x00, 0x06, 0x49, 0x89, 0x86, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x0c, 0x12, 0x0a, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0a, 0x00, 0x06, 0x09, 0x09, 0x47, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x0a, 0x00, 0x00, 0x06, 0x09, 0x49, 0x87, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x00, 0x0c, 0x12, 0x0a, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x14, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x0c, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x19, 0x21, 0x19, 0x21, 0x01, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x32, 0x42, 0x32, 0x42, 0x02, 0x86, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x18, 0x20, 0x10, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x06, 0x18, 0x20, 0x20, 0x10, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x42, 0x82, 0x82, 0x84, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x42, 0x82, 0x82, 0x84, 0x78, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x12, 0x3c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3c, 0x4b, 0x4a, 0x44, 0x40, 0x40, 0x40, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x32, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x32, 0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x08, 0x00, 0x00, 0x41, 0x81, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x41, 0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x22, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x10, 0x10, 0x68, 0x88, 0x74, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x40, 0x30, 0x4e, 0x49, 0x39, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x24, 0x28, 0xf3, 0x24, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0e, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x0f, 0x02, 0x04, 0x18, 0x60, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x88, 0x87, 0x81, 0x7e, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x88, 0x86, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x24, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x88, 0x87, 0x81, 0x7e, 0x00, 0x24, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x04, 0xf8, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0xf7, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00},
	{0x68, 0x90, 0x02, 0x22, 0x12, 0x0a, 0x04, 0x0c, 0x12, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x68, 0x90, 0x02, 0x32, 0x12, 0x0a, 0x0a, 0x0e, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x60, 0x80, 0x72, 0xa2, 0x12, 0x0a, 0x04, 0x0c, 0x12, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x30, 0x40, 0x3a, 0x52, 0x12, 0x0a, 0x0a, 0x0e, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x04, 0x0c, 0x12, 0x3c, 0x00, 0x18, 0x20, 0x1c, 0x20, 0x00},
	{0x00, 0x00, 0x22, 0x12, 0x12, 0x0a, 0x0a, 0x0e, 0x3d, 0x00, 0x00, 0x18, 0x20, 0x1c, 0x20, 0x00},
	{0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x04, 0x0c, 0x12, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x22, 0x12, 0x12, 0x0a, 0x0a, 0x0e, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xf1, 0x35, 0x55, 0x8a, 0xe0, 0x06, 0x95, 0xd6, 0xb5, 0x97, 0x00, 0xee, 0x8a, 0xee, 0x28, 0xe8},
	{0x00, 0x38, 0x7c, 0x7c, 0xc6, 0x92, 0xf2, 0xe6, 0xfe, 0xe6, 0x7c, 0x7c, 0x38, 0x00, 0x00, 0x00},

	/* Special glyph for unknown character */
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x0c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00}
};

/** @}
 */
