/*
 * Copyright (c) 2010 Radim Vansa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

 /** @addtogroup libc
 * @{
 */
/** @file
 */

#ifndef LIBC_DEVICE_NIC_H_
#define LIBC_DEVICE_NIC_H_

#include <async.h>
#include <net/device.h>
#include <net/packet.h>
#include <ipc/services.h>

typedef enum {
	NIC_SEND_MESSAGE = 0,
	NIC_CONNECT_TO_NIL,
	NIC_GET_STATE,
	NIC_SET_STATE,
	NIC_GET_ADDRESS,
	NIC_SET_ADDRESS,
	NIC_GET_STATS,
	NIC_GET_DEVICE_INFO,
	NIC_GET_CABLE_STATE,
	NIC_GET_OPERATION_MODE,
	NIC_SET_OPERATION_MODE,
	NIC_AUTONEG_ENABLE,
	NIC_AUTONEG_DISABLE,
	NIC_AUTONEG_PROBE,
	NIC_AUTONEG_RESTART,
	NIC_GET_PAUSE,
	NIC_SET_PAUSE,
	NIC_UNICAST_GET_MODE,
	NIC_UNICAST_SET_MODE,
	NIC_MULTICAST_GET_MODE,
	NIC_MULTICAST_SET_MODE,
	NIC_BROADCAST_GET_MODE,
	NIC_BROADCAST_SET_MODE,
	NIC_DEFECTIVE_GET_MODE,
	NIC_DEFECTIVE_SET_MODE,
	NIC_BLOCKED_SOURCES_GET,
	NIC_BLOCKED_SOURCES_SET,
	NIC_VLAN_GET_MASK,
	NIC_VLAN_SET_MASK,
	NIC_VLAN_SET_TAG,
	NIC_WOL_VIRTUE_ADD,
	NIC_WOL_VIRTUE_REMOVE,
	NIC_WOL_VIRTUE_PROBE,
	NIC_WOL_VIRTUE_LIST,
	NIC_WOL_VIRTUE_GET_CAPS,
	NIC_WOL_LOAD_INFO,
	NIC_OFFLOAD_PROBE,
	NIC_OFFLOAD_SET,
	NIC_POLL_GET_MODE,
	NIC_POLL_SET_MODE,
	NIC_POLL_NOW
} nic_funcs_t;

extern int nic_send_message(async_sess_t *, packet_id_t);
extern int nic_connect_to_nil(async_sess_t *, services_t, nic_device_id_t);
extern int nic_get_state(async_sess_t *, nic_device_state_t *);
extern int nic_set_state(async_sess_t *, nic_device_state_t);
extern int nic_get_address(async_sess_t *, nic_address_t *);
extern int nic_set_address(async_sess_t *, const nic_address_t *);
extern int nic_get_stats(async_sess_t *, nic_device_stats_t *);
extern int nic_get_device_info(async_sess_t *, nic_device_info_t *);
extern int nic_get_cable_state(async_sess_t *, nic_cable_state_t *);

extern int nic_get_operation_mode(async_sess_t *, int *, nic_channel_mode_t *,
    nic_role_t *);
extern int nic_set_operation_mode(async_sess_t *, int, nic_channel_mode_t,
    nic_role_t);
extern int nic_autoneg_enable(async_sess_t *, uint32_t);
extern int nic_autoneg_disable(async_sess_t *);
extern int nic_autoneg_probe(async_sess_t *, uint32_t *, uint32_t *,
    nic_result_t *, nic_result_t *);
extern int nic_autoneg_restart(async_sess_t *);
extern int nic_get_pause(async_sess_t *, nic_result_t *, nic_result_t *,
    uint16_t *);
extern int nic_set_pause(async_sess_t *, int, int, uint16_t);

extern int nic_unicast_get_mode(async_sess_t *, nic_unicast_mode_t *, size_t,
    nic_address_t *, size_t *);
extern int nic_unicast_set_mode(async_sess_t *, nic_unicast_mode_t,
    const nic_address_t *, size_t);
extern int nic_multicast_get_mode(async_sess_t *, nic_multicast_mode_t *,
    size_t, nic_address_t *, size_t *);
extern int nic_multicast_set_mode(async_sess_t *, nic_multicast_mode_t,
    const nic_address_t *, size_t);
extern int nic_broadcast_get_mode(async_sess_t *, nic_broadcast_mode_t *);
extern int nic_broadcast_set_mode(async_sess_t *, nic_broadcast_mode_t);
extern int nic_defective_get_mode(async_sess_t *, uint32_t *);
extern int nic_defective_set_mode(async_sess_t *, uint32_t);
extern int nic_blocked_sources_get(async_sess_t *, size_t, nic_address_t *,
    size_t *);
extern int nic_blocked_sources_set(async_sess_t *, const nic_address_t *,
    size_t);

extern int nic_vlan_get_mask(async_sess_t *, nic_vlan_mask_t *);
extern int nic_vlan_set_mask(async_sess_t *, const nic_vlan_mask_t *);
extern int nic_vlan_set_tag(async_sess_t *, uint16_t, bool, bool);

extern int nic_wol_virtue_add(async_sess_t *, nic_wv_type_t, const void *,
    size_t, nic_wv_id_t *);
extern int nic_wol_virtue_remove(async_sess_t *, nic_wv_id_t);
extern int nic_wol_virtue_probe(async_sess_t *, nic_wv_id_t, nic_wv_type_t *,
    size_t, void *, size_t *);
extern int nic_wol_virtue_list(async_sess_t *, nic_wv_type_t, size_t,
    nic_wv_id_t *, size_t *);
extern int nic_wol_virtue_get_caps(async_sess_t *, nic_wv_type_t, int *);
extern int nic_wol_load_info(async_sess_t *, nic_wv_type_t *, size_t, uint8_t *,
    size_t *);

extern int nic_offload_probe(async_sess_t *, uint32_t *, uint32_t *);
extern int nic_offload_set(async_sess_t *, uint32_t, uint32_t);

extern int nic_poll_get_mode(async_sess_t *, nic_poll_mode_t *,
    struct timeval *);
extern int nic_poll_set_mode(async_sess_t *, nic_poll_mode_t,
    const struct timeval *);
extern int nic_poll_now(async_sess_t *);

#endif

/** @}
 */
