/* Automatically generated by mknewcmd on Thursday 03 December 2020 11:32:57 AM
 * IST This is machine generated output. The author of mknewcmd claims no
 * copyright over the contents of this file. Where legally permitted, the
 * contents herein are donated to the public domain.
 *
 * You should apply any license and copyright that you wish to this file,
 * replacing this header in its entirety. */

#include "head.h"
#include <stdlib.h>
#include "cmds.h"
#include "config.h"
#include "entry.h"
#include "errors.h"
#include "stdio.h"
#include "string.h"
#include "util.h"

static const char *cmdname = "head";

/* Dispays help for head in various levels */
void help_cmd_head(unsigned int level)
{
	printf("This is the %s help for '%s'.\n", level ? EXT_HELP : SHORT_HELP,
	    cmdname);
	return;
}

static int getline(char **lineptr, size_t *n, FILE *stream)
{
	static char line[256];
	char *ptr;
	unsigned int len;

	if (lineptr == NULL || n == NULL) {
		errno = EINVAL;
		return -1;
	}

	if (ferror(stream))
		return -1;

	if (feof(stream))
		return -1;

	fgets(line, 256, stream);

	ptr = strchr(line, '\n');
	if (ptr)
		*ptr = '\0';

	len = strlen(line);

	if ((len + 1) < 256) {
		ptr = realloc(*lineptr, 256);
		if (ptr == NULL)
			return (-1);
		*lineptr = ptr;
		*n = 256;
	}

	strcpy(*lineptr, line);
	return (len);
}

/* Main entry point for head, accepts an array of arguments */
int cmd_head(char **argv)
{
	unsigned int argc;

	/* Count the arguments */
	for (argc = 0; argv[argc] != NULL; argc++)
		;

	FILE *fp;  // file pointer
	char *line = NULL;
	size_t len = 0;

	int cnt = 0;

	if (argc < 3) {
		printf("Insufficient Arguments!!!\n");
		printf("Please use \"program-name file-name N\" format.\n");
		return -1;
	}

	// open file
	fp = fopen(argv[1], "r");

	// checking for file is exist or not
	if (fp == NULL) {
		printf("\n%s file can not be opened !!!\n", argv[1]);
		return 1;
	}

	// read lines from file one by one
	while (getline(&line, &len, fp) != -1) {
		cnt++;
		if (cnt > atoi(argv[2]))
			break;

		printf("%s\n", line);
		fflush(stdout);
	}

	// close file
	fclose(fp);

	return CMD_SUCCESS;
}
