#include <stdio.h>
#include <stdint.h>

typedef uint32_t uint32_t;
typedef uint32_t ipl_t;
typedef uint32_t uintptr_t;

#define __mips32_TYPES_H__
#include "../../arch/mips32/include/context.h"
#include "../../arch/mips32/include/exception.h"

#define FILENAME "../../arch/mips32/include/context_offset.h"

int main(void)
{
	FILE *f;
	struct context *pctx = NULL;
	struct exception_regdump *edmp = NULL;
	

	f = fopen(FILENAME,"w");
	if (!f) {
		perror(FILENAME);
		return 1;
	}

	fprintf(f, "/* This file is automatically generated by %s. */\n", __FILE__);	

	fprintf(f,"/* struct context */\n");

	fprintf(f,"#define OFFSET_SP      0x%x\n", ((int) &pctx->sp) - (int) pctx);
	fprintf(f,"#define OFFSET_PC      0x%x\n", ((int) &pctx->pc) - (int) pctx);
	fprintf(f,"#define OFFSET_S0      0x%x\n", ((int) &pctx->s0) - (int) pctx);
	fprintf(f,"#define OFFSET_S1      0x%x\n", ((int) &pctx->s1) - (int) pctx);
	fprintf(f,"#define OFFSET_S2      0x%x\n", ((int) &pctx->s2) - (int) pctx);
	fprintf(f,"#define OFFSET_S3      0x%x\n", ((int) &pctx->s3) - (int) pctx);
	fprintf(f,"#define OFFSET_S4      0x%x\n", ((int) &pctx->s4) - (int) pctx);
	fprintf(f,"#define OFFSET_S5      0x%x\n", ((int) &pctx->s5) - (int) pctx);
	fprintf(f,"#define OFFSET_S6      0x%x\n", ((int) &pctx->s6) - (int) pctx);
	fprintf(f,"#define OFFSET_S7      0x%x\n", ((int) &pctx->s7) - (int) pctx);
	fprintf(f,"#define OFFSET_S8      0x%x\n", ((int) &pctx->s8) - (int) pctx);
	fprintf(f,"#define OFFSET_GP      0x%x\n", ((int) &pctx->gp) - (int) pctx);

	fprintf(f,"\n\n/* struct register_dump */\n");
	fprintf(f,"#define EOFFSET_AT     0x%x\n", ((int) &edmp->at) - (int) edmp);
	fprintf(f,"#define EOFFSET_V0     0x%x\n", ((int) &edmp->v0) - (int) edmp);
	fprintf(f,"#define EOFFSET_V1     0x%x\n", ((int) &edmp->v1) - (int) edmp);
	fprintf(f,"#define EOFFSET_A0     0x%x\n", ((int) &edmp->a0) - (int) edmp);
	fprintf(f,"#define EOFFSET_A1     0x%x\n", ((int) &edmp->a1) - (int) edmp);
	fprintf(f,"#define EOFFSET_A2     0x%x\n", ((int) &edmp->a2) - (int) edmp);
	fprintf(f,"#define EOFFSET_A3     0x%x\n", ((int) &edmp->a3) - (int) edmp);
	fprintf(f,"#define EOFFSET_T0     0x%x\n", ((int) &edmp->t0) - (int) edmp);
	fprintf(f,"#define EOFFSET_T1     0x%x\n", ((int) &edmp->t1) - (int) edmp);
	fprintf(f,"#define EOFFSET_T2     0x%x\n", ((int) &edmp->t2) - (int) edmp);
	fprintf(f,"#define EOFFSET_T3     0x%x\n", ((int) &edmp->t3) - (int) edmp);
	fprintf(f,"#define EOFFSET_T4     0x%x\n", ((int) &edmp->t4) - (int) edmp);
	fprintf(f,"#define EOFFSET_T5     0x%x\n", ((int) &edmp->t5) - (int) edmp);
	fprintf(f,"#define EOFFSET_T6     0x%x\n", ((int) &edmp->t6) - (int) edmp);
	fprintf(f,"#define EOFFSET_T7     0x%x\n", ((int) &edmp->t7) - (int) edmp);
	fprintf(f,"#define EOFFSET_S0     0x%x\n", ((int) &edmp->s0) - (int) edmp);
	fprintf(f,"#define EOFFSET_S1     0x%x\n", ((int) &edmp->s1) - (int) edmp);
	fprintf(f,"#define EOFFSET_S2     0x%x\n", ((int) &edmp->s2) - (int) edmp);
	fprintf(f,"#define EOFFSET_S3     0x%x\n", ((int) &edmp->s3) - (int) edmp);
	fprintf(f,"#define EOFFSET_S4     0x%x\n", ((int) &edmp->s4) - (int) edmp);
	fprintf(f,"#define EOFFSET_S5     0x%x\n", ((int) &edmp->s5) - (int) edmp);
	fprintf(f,"#define EOFFSET_S6     0x%x\n", ((int) &edmp->s6) - (int) edmp);
	fprintf(f,"#define EOFFSET_S7     0x%x\n", ((int) &edmp->s7) - (int) edmp);
	fprintf(f,"#define EOFFSET_T8     0x%x\n", ((int) &edmp->t8) - (int) edmp);
	fprintf(f,"#define EOFFSET_T9     0x%x\n", ((int) &edmp->t9) - (int) edmp);
	fprintf(f,"#define EOFFSET_GP     0x%x\n", ((int) &edmp->gp) - (int) edmp);
	fprintf(f,"#define EOFFSET_SP     0x%x\n", ((int) &edmp->sp) - (int) edmp);
	fprintf(f,"#define EOFFSET_S8     0x%x\n", ((int) &edmp->s8) - (int) edmp);
	fprintf(f,"#define EOFFSET_RA     0x%x\n", ((int) &edmp->ra) - (int) edmp);
	fprintf(f,"#define EOFFSET_LO     0x%x\n", ((int) &edmp->lo) - (int) edmp);
	fprintf(f,"#define EOFFSET_HI     0x%x\n", ((int) &edmp->hi) - (int) edmp);
	fprintf(f,"#define EOFFSET_STATUS 0x%x\n", ((int) &edmp->status) - (int) edmp);
	fprintf(f,"#define EOFFSET_EPC    0x%x\n", ((int) &edmp->epc) - (int) edmp);

	fprintf(f,"#define REGISTER_SPACE %d\n", sizeof(*edmp));

	fclose(f);

	return 0;
}
