/*
 * Copyright (c) 2006 Sergey Bondari
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup generic
 * @{
 */
/** @file
 */

#ifndef KERN_ELF_LOAD_H_
#define KERN_ELF_LOAD_H_

#include <arch/elf.h>

/**
 * ELF error return codes
 */
#define EE_OK             0  /* No error */
#define EE_INVALID        1  /* Invalid ELF image */
#define EE_MEMORY         2  /* Cannot allocate address space */
#define EE_INCOMPATIBLE   3  /* ELF image is not compatible with current architecture */
#define EE_UNSUPPORTED    4  /* Non-supported ELF (e.g. dynamic ELFs) */
#define EE_LOADER         5  /* The image is actually a program loader. */
#define EE_IRRECOVERABLE  6  /* Irrecoverable error. */

/**
 * This flags is passed when running the loader, otherwise elf_load()
 * would return with a EE_LOADER error code.
 */
#define ELD_F_NONE    0
#define ELD_F_LOADER  1

extern unsigned int elf_load(elf_header_t *, as_t *, unsigned int);
extern const char *elf_error(unsigned int rc);

#endif

/** @}
 */
