/*
 * Copyright (c) 2010 Vojtech Horky
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup libusb usb
 * @{
 */
/** @file
 * @brief Common definitions for both HC driver and hub driver.
 */
#ifndef LIBUSB_HCDHUBD_PRIVATE_H_
#define LIBUSB_HCDHUBD_PRIVATE_H_

#define USB_HUB_DEVICE_NAME "usbhub"
#define USB_KBD_DEVICE_NAME "hid"

extern link_t hc_list;
extern usb_hc_driver_t *hc_driver;

extern usbhc_iface_t usbhc_interface;

usb_address_t usb_get_address_by_handle(devman_handle_t);
int usb_add_hc_device(device_t *);

/** lowest allowed usb address */
extern int usb_lowest_address;

/** highest allowed usb address */
extern int usb_highest_address;

/**
 * @brief initialize address list of given hcd
 *
 * This function should be used only for hcd initialization.
 * It creates interval list of free addresses, thus it is initialized as
 * list with one interval with whole address space. Using an address shrinks
 * the interval, freeing an address extends an interval or creates a
 * new one. 
 *
 * @param hcd
 * @return
 */
void  usb_create_address_list(usb_hc_device_t * hcd);






#endif
/**
 * @}
 */
