/*
 * Copyright (c) 2016 Martin Decky
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#define CONTEXT_OFFSET_SP   0x00
#define CONTEXT_OFFSET_PC   0x08
#define CONTEXT_OFFSET_GP   0x10
#define CONTEXT_OFFSET_TP   0x18
#define CONTEXT_OFFSET_S0   0x20
#define CONTEXT_OFFSET_S1   0x28
#define CONTEXT_OFFSET_S2   0x30
#define CONTEXT_OFFSET_S3   0x38
#define CONTEXT_OFFSET_S4   0x40
#define CONTEXT_OFFSET_S5   0x48
#define CONTEXT_OFFSET_S6   0x50
#define CONTEXT_OFFSET_S7   0x58
#define CONTEXT_OFFSET_S8   0x60
#define CONTEXT_OFFSET_S9   0x68
#define CONTEXT_OFFSET_S10  0x70
#define CONTEXT_OFFSET_S11  0x78
#define CONTEXT_OFFSET_IPL  0x80
#define CONTEXT_SIZE        0x88

#ifndef __ASSEMBLER__

#include <typedefs.h>

typedef struct context {
	uint64_t sp;
	uint64_t pc;
	uint64_t gp;
	uint64_t tp;
	uint64_t s0;
	uint64_t s1;
	uint64_t s2;
	uint64_t s3;
	uint64_t s4;
	uint64_t s5;
	uint64_t s6;
	uint64_t s7;
	uint64_t s8;
	uint64_t s9;
	uint64_t s10;
	uint64_t s11;
	ipl_t ipl;
} context_t;

#endif

