/* Automatically generated by mknewcmd on Don Nov 29 19:01:45 CET 2018
 * This is machine generated output. The author of mknewcmd claims no
 * copyright over the contents of this file. Where legally permitted, the
 * contents herein are donated to the public domain.
 *
 * You should apply any license and copyright that you wish to this file,
 * replacing this header in its entirety. */

#include <stdio.h>
#include <stdlib.h>
#include <str.h>
#include "config.h"
#include "util.h"
#include "errors.h"
#include "entry.h"
#include "alias.h"
#include "cmds.h"

#include <adt/odict.h>


static const char *cmdname = "alias";
static const char* alias_format = "%s='%s'\n";



static void list_aliases()
{
	odlink_t *alias_link = odict_first(&alias_dict);
	while (alias_link != NULL) {
		alias_t *data = odict_get_instance(alias_link, alias_t, odict);

		printf(alias_format, data->name, data->value);

		alias_link = odict_next(alias_link, &alias_dict);
	}
}


static bool print_alias(const char* name)
{
	odlink_t *alias_link = odict_find_eq(&alias_dict, (void*)name, NULL);
	if (alias_link != NULL) {
		alias_t* data = odict_get_instance(alias_link, alias_t, odict);
		printf(alias_format, data->name, data->value);
		return true;
	}



	printf("%s: No alias with the name '%s' exists\n", cmdname, name);
	return false;
}


static void set_alias(const char* name, const char* value)
{
	odlink_t *alias_link = odict_find_eq(&alias_dict, (void*)name, NULL);

	if (alias_link != NULL) {
		//update existing value
		alias_t* data = odict_get_instance(alias_link, alias_t, odict);
		free(data->value);
		data->value = str_dup(value);

		printf("%s: update value ", cmdname);
	}else {
		//add new value
		alias_t* data = (alias_t*)calloc(1, sizeof(alias_t));
		data->name = str_dup(name);
		data->value = str_dup(value);

		odict_insert(&data->odict, &alias_dict, NULL);


		printf("%s: insert value ", cmdname);
	}

	printf(alias_format, name, value);
}





/* Dispays help for alias in various levels */
void help_cmd_alias(unsigned int level)
{
	printf("Set a new alias with \"alias hex='cat --hex'\". Display an alias with \"alias hex\". List all alias by passing no argument.\n");
	return;
}

/* Main entry point for alias, accepts an array of arguments */
int cmd_alias(char **argv)
{
	
	if (argv[1] == NULL) {
		list_aliases();
		return CMD_SUCCESS;
	}


	size_t i;
	for (i = 1; argv[i] != NULL; i++) {
		char* pos;
		if ((pos = str_chr(argv[i], '=')) != NULL) {
			argv[i][pos - argv[i]] = '\0';
			set_alias(argv[i], pos + 1);
		}else {
			if(!print_alias(argv[i])) {
				return CMD_FAILURE;
			}
		}
	}
	
	return CMD_SUCCESS;
}

