/*
 * Copyright (c) 2013 Martin Sucha
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup genericlog
 * @{
 */
/** @file
 */

#ifndef KERN_LOG_H_
#define KERN_LOG_H_

#include <errno.h>
#include <stdarg.h>
#include <stddef.h>
#include <printf/verify.h>
#include <abi/log.h>
#include <abi/klog.h>

extern void log_init(void);
extern void log_begin(log_facility_t, log_level_t);
extern void log_end(void);
extern int log_vprintf(const char *, va_list);
extern int log_printf(const char *, ...)
    _HELENOS_PRINTF_ATTRIBUTE(1, 2);
extern int log(log_facility_t, log_level_t, const char *, ...)
    _HELENOS_PRINTF_ATTRIBUTE(3, 4);

extern sys_errno_t sys_klog(sysarg_t, void *buf, size_t size,
    sysarg_t level, size_t *uspace_nread);

#endif /* KERN_LOG_H_ */

/** @}
 */
