/*
 * Copyright (c) 2020 Jiri Svoboda
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup libui
 * @{
 */
/**
 * @file Window
 */

#ifndef _UI_TYPES_WINDOW_H
#define _UI_TYPES_WINDOW_H

#include <errno.h>
#include <io/kbd_event.h>
#include <io/pos_event.h>

struct ui_window;
typedef struct ui_window ui_window_t;

/** Window placement hint */
typedef enum {
	/** Use default (automatic) placement */
	ui_wnd_place_default = 0,
	/** Place window to the top-left corner of the screen */
	ui_wnd_place_top_left,
	/** Place window to the top-right corner of the screen */
	ui_wnd_place_top_right,
	/** Place window to the bottom-left corner of the screen */
	ui_wnd_place_bottom_left,
	/** Place window to the bottom-right corner of the screen */
	ui_wnd_place_bottom_right
} ui_wnd_placement_t;

/** Window parameters */
typedef struct {
	/** Window rectangle */
	gfx_rect_t rect;
	/** Window caption */
	const char *caption;
	/** Window placement */
	ui_wnd_placement_t placement;
} ui_wnd_params_t;

/** Window callbacks */
typedef struct ui_window_cb {
	void (*close)(ui_window_t *, void *);
	void (*focus)(ui_window_t *, void *);
	void (*kbd)(ui_window_t *, void *, kbd_event_t *);
	errno_t (*paint)(ui_window_t *, void *);
	void (*pos)(ui_window_t *, void *, pos_event_t *);
	void (*unfocus)(ui_window_t *, void *);
} ui_window_cb_t;

#endif

/** @}
 */
