/*
 * Copyright (c) 2011 Petr Koupy
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup libposix
 * @{
 */
/** @file
 */

#ifndef POSIX_FNMATCH_H_
#define POSIX_FNMATCH_H_

/* fnmatch flags */
#undef FNM_PATHNAME
#undef FNM_NOESCAPE
#undef FNM_PERIOD
#define	FNM_PATHNAME  (1 << 0) /* Slash cannot be matched to the wildcard. */
#define	FNM_NOESCAPE  (1 << 1) /* Disable backslash escaping. */
#define	FNM_PERIOD    (1 << 2) /* Leading period must be exactly matched. */

/* fnmatch return values */
#undef FNM_NOMATCH
#undef FNM_NOSYS
#define	FNM_NOMATCH          1 /* The string does not match the pattern. */
#define FNM_NOSYS	      (-1) /* In case fnmatch is not supported. */

extern int posix_fnmatch(const char *pattern, const char *string, int flags);

#ifndef LIBPOSIX_INTERNAL
	#define fnmatch posix_fnmatch
#endif

#endif /* POSIX_FNMATCH_H_ */

/** @}
 */
