/*
 *  PPC linker script
 *
 */

OUTPUT_FORMAT("elf32-powerpc")
OUTPUT_ARCH(powerpc:common)
ENTRY(start)

SECTIONS {
	.boot 0x10000000: AT (0) { 
		*(BOOTSTRAP);
		*(REALMODE);
		*(.text);
		
		*(.rodata);
		*(.rodata.*);
		*(.data);		/* initialized data */
		*(.sdata);
		*(.sdata2);
		*(.sbss);
		*(.bss);		/* uninitialized static variables */	
		*(COMMON); 		/* global variables */
		
		. = ALIGN(4096);
		*(.kernel_image);
		
		. = ALIGN(4096);
		*(.init_image);
	}
}
