/*
 *  SPARC64 linker script
 *
 *  It is ELF format, but its only section looks like this:
 *  kernel text
 *  kernel data
 *
 */

OUTPUT_FORMAT(elf64-sparc)
ENTRY(kernel_image_start)

SECTIONS {
	.image 0x4000: AT (0x4000) { 
		ktext_start = .;
		*(K_TEXT_START)
		*(.text);
		ktext_end = .;
		
		kdata_start = .;
		*(K_DATA_START)
		*(.rodata);
		*(.rodata.*);
		*(.data);		/* initialized data */
		*(.sdata);
		*(.sdata2);
		*(.sbss);
		hardcoded_ktext_size = .;
		LONG(ktext_end - ktext_start);	
		hardcoded_kdata_size = .;
		LONG(kdata_end - kdata_start);
		hardcoded_load_address = .;
		QUAD(0x4000);
		*(.bss);		/* uninitialized static variables */	
		*(COMMON); 		/* global variables */

		symbol_table = .;
                *(symtab.*);            /* Symbol table, must be LAST symbol!*/

		kdata_end = .;
	}
	
	/DISCARD/ : {
		*(.comment);
		*(.note*);
	}

}
