/*
 * Copyright (c) 2010 Jan Vesely
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/** @addtogroup usb
 * @{
 */
/** @file
 * @brief UHCI driver
 */
#ifndef DRV_UHCI_UTIL_SYNCHRONIZER_H
#define DRV_UHCI_UTIL_SYNCHRONIZER_H

#include <assert.h>
#include <driver.h>
#include <usb/usb.h>

#include "debug.h"
#include "utils/fibril_semaphore.h"

typedef struct value
{
	/* TODO Think of better fibril synch to use */
	usb_transaction_outcome_t result;
	size_t size;
	fibril_semaphore_t done;
} sync_value_t;

void sync_init(sync_value_t *value);

void sync_wait_for(sync_value_t *value);

void sync_in_callback(
  device_t *device, usb_transaction_outcome_t result, size_t size, void *value);

void sync_out_callback(
  device_t *device, usb_transaction_outcome_t result, void *value);

int uhci_setup_sync(
  device_t *hc,
  usb_target_t target,
  usb_transfer_type_t type,
  void *buffer, size_t size,
  sync_value_t *result
  );
#endif
/**
 * @}
 */
