#
# Copyright (C) 2001-2004 Jakub Jermar
# Copyright (C) 2005-2006 Martin Decky
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# - Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
# - Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in the
#   documentation and/or other materials provided with the distribution.
# - The name of the author may not be used to endorse or promote products
#   derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#include <arch/boot/boot.h>
#include <arch/mm/page.h>
#include <arch/pm.h>

.section __xen_guest
	.ascii  "GUEST_OS=HelenOS,"
	.ascii  "XEN_VER=xen-3.0,"
	.ascii  "HYPERCALL_PAGE=0x2,"
	.ascii  "LOADER=generic,"
	.ascii  "PT_MODE_WRITABLE"
	.byte   0

.text

.code32
.align 4
.global kernel_image_start
	
kernel_image_start:
	cld
	movl $kernel_stack, %esp         # initialize stack pointer
	
	call main_bsp								# never returns

	cli
	hlt

.data

.align 4096
page_directory:
	.space 4096, 0

kernel_stack_bottom:
	.space TEMP_STACK_SIZE
kernel_stack:
